/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.specloader.specimpl;

import org.apache.isis.applib.annotation.Where;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.debug.DebugString;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.commons.util.ToString;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.consent.Consent;
import org.apache.isis.core.metamodel.consent.InteractionInvocationMethod;
import org.apache.isis.core.metamodel.consent.InteractionResult;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetedMethod;
import org.apache.isis.core.metamodel.facets.accessor.PropertyOrCollectionAccessorFacet;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionAddToFacet;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionClearFacet;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionFacet;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionFacetUtils;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionRemoveFromFacet;
import org.apache.isis.core.metamodel.interactions.CollectionAddToContext;
import org.apache.isis.core.metamodel.interactions.CollectionRemoveFromContext;
import org.apache.isis.core.metamodel.interactions.CollectionUsabilityContext;
import org.apache.isis.core.metamodel.interactions.CollectionVisibilityContext;
import org.apache.isis.core.metamodel.interactions.InteractionUtils;
import org.apache.isis.core.metamodel.interactions.UsabilityContext;
import org.apache.isis.core.metamodel.interactions.ValidityContext;
import org.apache.isis.core.metamodel.interactions.VisibilityContext;
import org.apache.isis.core.metamodel.spec.Instance;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.ObjectMemberContext;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToManyFeature;
import org.apache.isis.core.metamodel.specloader.specimpl.ObjectAssociationAbstract;

public class OneToManyAssociationImpl
extends ObjectAssociationAbstract
implements OneToManyAssociation {
    public OneToManyAssociationImpl(FacetedMethod facetedMethod, ObjectMemberContext objectMemberContext) {
        this(facetedMethod, OneToManyAssociationImpl.getSpecification(objectMemberContext.getSpecificationLookup(), facetedMethod.getType()), objectMemberContext);
    }

    protected OneToManyAssociationImpl(FacetedMethod facetedMethod, ObjectSpecification objectSpec, ObjectMemberContext objectMemberContext) {
        super(facetedMethod, FeatureType.COLLECTION, objectSpec, objectMemberContext);
    }

    @Override
    public OneToManyFeature.CollectionSemantics getCollectionSemantics() {
        Class<?> underlyingClass = this.getSpecification().getCorrespondingClass();
        return this.getCollectionTypeRegistry().semanticsOf(underlyingClass);
    }

    @Override
    public VisibilityContext<?> createVisibleInteractionContext(AuthenticationSession session, InteractionInvocationMethod invocationMethod, ObjectAdapter ownerAdapter, Where where) {
        return new CollectionVisibilityContext(this.getDeploymentCategory(), session, invocationMethod, ownerAdapter, this.getIdentifier(), where);
    }

    @Override
    public UsabilityContext<?> createUsableInteractionContext(AuthenticationSession session, InteractionInvocationMethod invocationMethod, ObjectAdapter ownerAdapter, Where where) {
        return new CollectionUsabilityContext(this.getDeploymentCategory(), session, invocationMethod, ownerAdapter, this.getIdentifier(), where);
    }

    @Override
    public ValidityContext<?> createValidateAddInteractionContext(AuthenticationSession session, InteractionInvocationMethod invocationMethod, ObjectAdapter ownerAdapter, ObjectAdapter proposedToAddAdapter) {
        return new CollectionAddToContext(this.getDeploymentCategory(), session, invocationMethod, ownerAdapter, this.getIdentifier(), proposedToAddAdapter);
    }

    @Override
    public Consent isValidToAdd(ObjectAdapter ownerAdapter, ObjectAdapter proposedToAddAdapter) {
        return this.isValidToAddResult(ownerAdapter, proposedToAddAdapter).createConsent();
    }

    private InteractionResult isValidToAddResult(ObjectAdapter ownerAdapter, ObjectAdapter proposedToAddAdapter) {
        ValidityContext<?> validityContext = this.createValidateAddInteractionContext(this.getAuthenticationSession(), InteractionInvocationMethod.BY_USER, ownerAdapter, proposedToAddAdapter);
        return InteractionUtils.isValidResult(this, validityContext);
    }

    @Override
    public ValidityContext<?> createValidateRemoveInteractionContext(AuthenticationSession session, InteractionInvocationMethod invocationMethod, ObjectAdapter ownerAdapter, ObjectAdapter proposedToRemoveAdapter) {
        return new CollectionRemoveFromContext(this.getDeploymentCategory(), session, invocationMethod, ownerAdapter, this.getIdentifier(), proposedToRemoveAdapter);
    }

    @Override
    public Consent isValidToRemove(ObjectAdapter ownerAdapter, ObjectAdapter proposedToRemoveAdapter) {
        return this.isValidToRemoveResult(ownerAdapter, proposedToRemoveAdapter).createConsent();
    }

    private InteractionResult isValidToRemoveResult(ObjectAdapter ownerAdapter, ObjectAdapter proposedToRemoveAdapter) {
        ValidityContext<?> validityContext = this.createValidateRemoveInteractionContext(this.getAuthenticationSession(), InteractionInvocationMethod.BY_USER, ownerAdapter, proposedToRemoveAdapter);
        return InteractionUtils.isValidResult(this, validityContext);
    }

    private boolean readWrite() {
        return !this.isNotPersisted();
    }

    @Override
    public ObjectAdapter get(ObjectAdapter ownerAdapter) {
        PropertyOrCollectionAccessorFacet accessor = this.getFacet(PropertyOrCollectionAccessorFacet.class);
        Object collection = accessor.getProperty(ownerAdapter);
        if (collection == null) {
            return null;
        }
        return this.getAdapterManager().adapterFor(collection, ownerAdapter, this);
    }

    @Override
    public boolean isEmpty(ObjectAdapter parentAdapter) {
        ObjectAdapter collection = this.get(parentAdapter);
        CollectionFacet facet = CollectionFacetUtils.getCollectionFacetFromSpec(collection);
        return facet.size(collection) == 0;
    }

    @Override
    public void addElement(ObjectAdapter ownerAdapter, ObjectAdapter referencedAdapter) {
        if (referencedAdapter == null) {
            throw new IllegalArgumentException("Can't use null to add an item to a collection");
        }
        if (this.readWrite()) {
            if (ownerAdapter.representsPersistent() && referencedAdapter.isTransient()) {
                throw new IsisException("can't set a reference to a transient object from a persistent one: " + ownerAdapter.titleString() + " (persistent) -> " + referencedAdapter.titleString() + " (transient)");
            }
            CollectionAddToFacet facet = this.getFacet(CollectionAddToFacet.class);
            facet.add(ownerAdapter, referencedAdapter);
        }
    }

    @Override
    public void removeElement(ObjectAdapter ownerAdapter, ObjectAdapter referencedAdapter) {
        if (referencedAdapter == null) {
            throw new IllegalArgumentException("element should not be null");
        }
        if (this.readWrite()) {
            CollectionRemoveFromFacet facet = this.getFacet(CollectionRemoveFromFacet.class);
            facet.remove(ownerAdapter, referencedAdapter);
        }
    }

    public void removeAllAssociations(ObjectAdapter ownerAdapter) {
        CollectionClearFacet facet = this.getFacet(CollectionClearFacet.class);
        facet.clear(ownerAdapter);
    }

    @Override
    public void clearCollection(ObjectAdapter ownerAdapter) {
        if (this.readWrite()) {
            CollectionClearFacet facet = this.getFacet(CollectionClearFacet.class);
            facet.clear(ownerAdapter);
        }
    }

    @Override
    public ObjectAdapter getDefault(ObjectAdapter ownerAdapter) {
        return null;
    }

    @Override
    public void toDefault(ObjectAdapter ownerAdapter) {
    }

    @Override
    public ObjectAdapter[] getChoices(ObjectAdapter ownerAdapter) {
        return new ObjectAdapter[0];
    }

    @Override
    public boolean hasChoices() {
        return false;
    }

    @Override
    public boolean hasAutoComplete() {
        return false;
    }

    @Override
    public ObjectAdapter[] getAutoComplete(ObjectAdapter object, String searchArg) {
        return new ObjectAdapter[0];
    }

    @Override
    public int getAutoCompleteMinLength() {
        return 0;
    }

    @Override
    public Instance getInstance(ObjectAdapter adapter) {
        OneToManyAssociationImpl specification = this;
        return adapter.getInstance(specification);
    }

    @Override
    public String debugData() {
        DebugString debugString = new DebugString();
        debugString.indent();
        debugString.indent();
        this.getFacetedMethod().debugData(debugString);
        return debugString.toString();
    }

    @Override
    public String toString() {
        ToString str = new ToString(this);
        str.append(super.toString());
        str.append(",");
        str.append("persisted", !this.isNotPersisted());
        str.append("type", this.getSpecification() == null ? "unknown" : this.getSpecification().getShortIdentifier());
        return str.toString();
    }
}

