/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.specloader.traverser;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

abstract class TypeExtractorAbstract
implements Iterable<Class<?>> {
    private final Method method;
    private final List<Class<?>> classes = new ArrayList();

    public TypeExtractorAbstract(Method method) {
        this.method = method;
    }

    protected void addParameterizedTypes(Type ... genericTypes) {
        for (Type genericType : genericTypes) {
            Type[] typeArguments;
            if (!(genericType instanceof ParameterizedType)) continue;
            ParameterizedType parameterizedType = (ParameterizedType)genericType;
            for (Type type : typeArguments = parameterizedType.getActualTypeArguments()) {
                if (!(type instanceof Class)) continue;
                Class cls = (Class)type;
                this.add(cls);
            }
        }
    }

    protected void add(Class<?> cls) {
        if (cls == Void.TYPE) {
            return;
        }
        this.classes.add(cls);
    }

    protected Method getMethod() {
        return this.method;
    }

    public List<Class<?>> getClasses() {
        return Collections.unmodifiableList(this.classes);
    }

    @Override
    public Iterator<Class<?>> iterator() {
        return this.getClasses().iterator();
    }
}

