/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.specloader.validator;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.apache.isis.core.metamodel.spec.SpecificationLoaderSpi;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidator;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorAbstract;
import org.apache.isis.core.metamodel.specloader.validator.ValidationFailures;

public class MetaModelValidatorComposite
extends MetaModelValidatorAbstract {
    private final List<MetaModelValidator> validators = Lists.newArrayList();

    @Override
    public void validate(ValidationFailures validationFailures) {
        for (MetaModelValidator validator : this.validators) {
            validator.validate(validationFailures);
        }
    }

    public MetaModelValidatorComposite add(MetaModelValidator validator) {
        this.validators.add(validator);
        return this;
    }

    public List<MetaModelValidator> getValidators() {
        return Collections.unmodifiableList(this.validators);
    }

    @Override
    public void setSpecificationLoaderSpi(SpecificationLoaderSpi specificationLoader) {
        super.setSpecificationLoaderSpi(specificationLoader);
        for (MetaModelValidator validator : this.validators) {
            validator.setSpecificationLoaderSpi(specificationLoader);
        }
    }

    public static MetaModelValidatorComposite asComposite(MetaModelValidator baseMetaModelValidator) {
        MetaModelValidatorComposite metaModelValidatorComposite = new MetaModelValidatorComposite();
        metaModelValidatorComposite.add(baseMetaModelValidator);
        return metaModelValidatorComposite;
    }
}

