/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.app;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.isis.applib.DomainObjectContainer;
import org.apache.isis.core.commons.components.ApplicationScopedComponent;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.config.IsisConfigurationDefault;
import org.apache.isis.core.commons.ensure.Ensure;
import org.apache.isis.core.metamodel.facetdecorator.FacetDecorator;
import org.apache.isis.core.metamodel.progmodel.ProgrammingModel;
import org.apache.isis.core.metamodel.runtimecontext.RuntimeContext;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjector;
import org.apache.isis.core.metamodel.services.container.DomainObjectContainerDefault;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.SpecificationLoaderSpi;
import org.apache.isis.core.metamodel.specloader.ObjectReflectorDefault;
import org.apache.isis.core.metamodel.specloader.classsubstitutor.ClassSubstitutor;
import org.apache.isis.core.metamodel.specloader.classsubstitutor.ClassSubstitutorAbstract;
import org.apache.isis.core.metamodel.specloader.collectiontyperegistry.CollectionTypeRegistry;
import org.apache.isis.core.metamodel.specloader.collectiontyperegistry.CollectionTypeRegistryDefault;
import org.apache.isis.core.metamodel.specloader.traverser.SpecificationTraverser;
import org.apache.isis.core.metamodel.specloader.traverser.SpecificationTraverserDefault;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidator;
import org.apache.isis.core.metamodel.specloader.validator.ValidationFailures;
import org.apache.isis.core.progmodel.metamodelvalidator.dflt.MetaModelValidatorDefault;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public class IsisMetaModel
implements ApplicationScopedComponent {
    private final List<Object> services = Lists.newArrayList();
    private State state = State.NOT_INITIALIZED;
    private ObjectReflectorDefault reflector;
    private RuntimeContext runtimeContext;
    private IsisConfiguration configuration;
    private ClassSubstitutor classSubstitutor;
    private CollectionTypeRegistry collectionTypeRegistry;
    private ProgrammingModel programmingModel;
    private SpecificationTraverser specificationTraverser;
    private Set<FacetDecorator> facetDecorators;
    private MetaModelValidator metaModelValidator;
    private DomainObjectContainer container;
    private ValidationFailures validationFailures;

    public static Builder builder(RuntimeContext runtimeContext, ProgrammingModel programmingModel) {
        return new Builder(runtimeContext, programmingModel);
    }

    public IsisMetaModel(RuntimeContext runtimeContext, ProgrammingModel programmingModel, List<Object> services) {
        this(runtimeContext, programmingModel, services.toArray());
    }

    public IsisMetaModel(RuntimeContext runtimeContext, ProgrammingModel programmingModel, Object ... services) {
        this.runtimeContext = runtimeContext;
        this.setContainer(new DomainObjectContainerDefault());
        this.services.addAll(Arrays.asList(services));
        this.setConfiguration(new IsisConfigurationDefault());
        this.setClassSubstitutor(new ClassSubstitutorAbstract(){});
        this.setCollectionTypeRegistry(new CollectionTypeRegistryDefault());
        this.setSpecificationTraverser(new SpecificationTraverserDefault());
        this.setFacetDecorators(new TreeSet<FacetDecorator>());
        this.setProgrammingModelFacets(programmingModel);
        this.setMetaModelValidator(new MetaModelValidatorDefault());
    }

    private void setContainer(DomainObjectContainer container) {
        this.container = container;
    }

    public List<Object> getServices() {
        return Collections.unmodifiableList(this.services);
    }

    @Override
    public void init() {
        this.ensureNotInitialized();
        this.reflector = new ObjectReflectorDefault(this.configuration, this.classSubstitutor, this.collectionTypeRegistry, this.specificationTraverser, this.programmingModel, this.facetDecorators, this.metaModelValidator);
        this.reflector.setContainer(this.container);
        this.reflector.setServices(this.services);
        this.runtimeContext.injectInto(this.container);
        this.runtimeContext.setContainer(this.container);
        this.runtimeContext.injectInto(this.reflector);
        this.reflector.injectInto(this.runtimeContext);
        this.validationFailures = this.reflector.initAndValidate();
        this.runtimeContext.init();
        for (Object service : this.services) {
            ObjectSpecification serviceSpec = this.reflector.loadSpecification(service.getClass());
            serviceSpec.markAsService();
        }
        this.state = State.INITIALIZED;
    }

    public ValidationFailures getValidationFailures() {
        return this.validationFailures;
    }

    @Override
    public void shutdown() {
        this.ensureInitialized();
        this.state = State.SHUTDOWN;
    }

    public SpecificationLoaderSpi getSpecificationLoader() {
        return this.reflector;
    }

    public DomainObjectContainer getDomainObjectContainer() {
        this.ensureInitialized();
        return this.container;
    }

    public ServicesInjector getDependencyInjector() {
        this.ensureInitialized();
        return this.runtimeContext.getDependencyInjector();
    }

    public IsisConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(IsisConfiguration configuration) {
        this.ensureNotInitialized();
        Ensure.ensureThatArg(configuration, CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.configuration = configuration;
    }

    public ClassSubstitutor getClassSubstitutor() {
        return this.classSubstitutor;
    }

    public void setClassSubstitutor(ClassSubstitutor classSubstitutor) {
        this.ensureNotInitialized();
        Ensure.ensureThatArg(classSubstitutor, CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.classSubstitutor = classSubstitutor;
    }

    public CollectionTypeRegistry getCollectionTypeRegistry() {
        return this.collectionTypeRegistry;
    }

    public void setCollectionTypeRegistry(CollectionTypeRegistry collectionTypeRegistry) {
        this.ensureNotInitialized();
        Ensure.ensureThatArg(collectionTypeRegistry, CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.collectionTypeRegistry = collectionTypeRegistry;
    }

    public SpecificationTraverser getSpecificationTraverser() {
        return this.specificationTraverser;
    }

    public void setSpecificationTraverser(SpecificationTraverser specificationTraverser) {
        this.specificationTraverser = specificationTraverser;
    }

    public ProgrammingModel getProgrammingModelFacets() {
        return this.programmingModel;
    }

    public void setProgrammingModelFacets(ProgrammingModel programmingModel) {
        this.ensureNotInitialized();
        Ensure.ensureThatArg(programmingModel, CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.programmingModel = programmingModel;
    }

    public Set<FacetDecorator> getFacetDecorators() {
        return Collections.unmodifiableSet(this.facetDecorators);
    }

    public void setFacetDecorators(Set<FacetDecorator> facetDecorators) {
        this.ensureNotInitialized();
        Ensure.ensureThatArg(facetDecorators, CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.facetDecorators = facetDecorators;
    }

    public MetaModelValidator getMetaModelValidator() {
        return this.metaModelValidator;
    }

    public void setMetaModelValidator(MetaModelValidator metaModelValidator) {
        this.metaModelValidator = metaModelValidator;
    }

    private State ensureNotInitialized() {
        return Ensure.ensureThatState(this.state, CoreMatchers.is((Object)((Object)State.NOT_INITIALIZED)));
    }

    private State ensureInitialized() {
        return Ensure.ensureThatState(this.state, CoreMatchers.is((Object)((Object)State.INITIALIZED)));
    }

    public static class Builder {
        private final RuntimeContext runtimeContext;
        private final ProgrammingModel programmingModel;
        private DomainObjectContainer container = new DomainObjectContainerDefault();
        private List<Object> services = Lists.newArrayList();

        private Builder(RuntimeContext embeddedContext, ProgrammingModel programmingModel) {
            this.runtimeContext = embeddedContext;
            this.programmingModel = programmingModel;
        }

        public Builder with(DomainObjectContainer container) {
            this.container = container;
            return this;
        }

        public Builder withServices(Object ... services) {
            return this.withServices(Arrays.asList(services));
        }

        public Builder withServices(List<Object> services) {
            this.services = services;
            return this;
        }

        public IsisMetaModel build() {
            IsisMetaModel isisMetaModel = new IsisMetaModel(this.runtimeContext, this.programmingModel, this.services);
            if (this.container != null) {
                isisMetaModel.setContainer(this.container);
            }
            return isisMetaModel;
        }
    }

    private static enum State {
        NOT_INITIALIZED,
        INITIALIZED,
        SHUTDOWN;

    }
}

