/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facetdecorators.help;

import org.apache.isis.applib.Identifier;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.IdentifiedHolder;
import org.apache.isis.core.metamodel.facetdecorator.FacetDecoratorAbstract;
import org.apache.isis.core.metamodel.facets.help.HelpFacet;
import org.apache.isis.core.progmodel.facetdecorators.help.HelpFacetDecorator;
import org.apache.isis.core.progmodel.facetdecorators.help.HelpFacetLookedUpViaHelpManager;
import org.apache.isis.core.progmodel.facetdecorators.help.HelpManager;

public class HelpFacetDecoratorUsingHelpManager
extends FacetDecoratorAbstract
implements HelpFacetDecorator {
    private final HelpManager helpManager;

    public HelpFacetDecoratorUsingHelpManager(HelpManager manager) {
        this.helpManager = manager;
    }

    @Override
    public Facet decorate(Facet facet, FacetHolder facetHolder) {
        if (facet.facetType() != HelpFacet.class) {
            return facet;
        }
        if (!(facetHolder instanceof IdentifiedHolder)) {
            return null;
        }
        IdentifiedHolder identifiedHolder = (IdentifiedHolder)facetHolder;
        return this.decorateWithHelpFacet(facet, identifiedHolder);
    }

    private Facet decorateWithHelpFacet(Facet facet, IdentifiedHolder identifiedHolder) {
        Identifier identifier = identifiedHolder.getIdentifier();
        String helpText = this.helpManager.getHelpText(identifier);
        if (helpText != null) {
            HelpFacetLookedUpViaHelpManager decoratingFacet = new HelpFacetLookedUpViaHelpManager(helpText, facet.getFacetHolder());
            identifiedHolder.addFacet(decoratingFacet);
            return decoratingFacet;
        }
        return null;
    }

    @Override
    public Class<? extends Facet>[] getFacetTypes() {
        return new Class[]{HelpFacet.class};
    }
}

