/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facetdecorators.i18n;

import org.apache.isis.applib.Identifier;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.IdentifiedHolder;
import org.apache.isis.core.metamodel.facetdecorator.FacetDecoratorAbstract;
import org.apache.isis.core.metamodel.facets.describedas.DescribedAsFacet;
import org.apache.isis.core.metamodel.facets.help.HelpFacet;
import org.apache.isis.core.metamodel.facets.named.NamedFacet;
import org.apache.isis.core.progmodel.facetdecorators.i18n.I18nManager;
import org.apache.isis.core.progmodel.facetdecorators.i18n.internal.DescribedAsFacetWrapI18n;
import org.apache.isis.core.progmodel.facetdecorators.i18n.internal.HelpFacetWrapI18n;
import org.apache.isis.core.progmodel.facetdecorators.i18n.internal.NamedFacetWrapI18n;

public class I18nFacetDecorator
extends FacetDecoratorAbstract {
    private final I18nManager i18nManager;

    public I18nFacetDecorator(I18nManager manager) {
        this.i18nManager = manager;
    }

    @Override
    public Facet decorate(Facet facet, FacetHolder facetHolder) {
        if (!(facetHolder instanceof IdentifiedHolder)) {
            return null;
        }
        IdentifiedHolder identifiedHolder = (IdentifiedHolder)facetHolder;
        Class<? extends Facet> facetType = facet.facetType();
        if (facetType == NamedFacet.class) {
            return this.decorateWithNamedFacet(facet, identifiedHolder);
        }
        if (facetType == DescribedAsFacet.class) {
            return this.decorateWithDescribedAsFacet(facet, identifiedHolder);
        }
        if (facetType == HelpFacet.class) {
            return this.decorateWithHelpFacet(facet, identifiedHolder);
        }
        return null;
    }

    private Facet decorateWithNamedFacet(Facet facet, IdentifiedHolder identifiedHolder) {
        Identifier identifier = identifiedHolder.getIdentifier();
        String i18nName = this.i18nManager.getName(identifier);
        if (i18nName == null) {
            return null;
        }
        NamedFacetWrapI18n decoratingFacet = new NamedFacetWrapI18n(i18nName, facet.getFacetHolder());
        identifiedHolder.addFacet(decoratingFacet);
        return decoratingFacet;
    }

    private Facet decorateWithDescribedAsFacet(Facet facet, IdentifiedHolder identifiedHolder) {
        Identifier identifier = identifiedHolder.getIdentifier();
        String i18nDescription = this.i18nManager.getDescription(identifier);
        if (i18nDescription == null) {
            return null;
        }
        DescribedAsFacetWrapI18n decoratingFacet = new DescribedAsFacetWrapI18n(i18nDescription, facet.getFacetHolder());
        identifiedHolder.addFacet(decoratingFacet);
        return decoratingFacet;
    }

    private Facet decorateWithHelpFacet(Facet facet, IdentifiedHolder identifiedHolder) {
        Identifier identifier = identifiedHolder.getIdentifier();
        String i18nHelp = this.i18nManager.getHelp(identifier);
        if (i18nHelp == null) {
            return null;
        }
        HelpFacetWrapI18n decoratingFacet = new HelpFacetWrapI18n(i18nHelp, facet.getFacetHolder());
        identifiedHolder.addFacet(decoratingFacet);
        return decoratingFacet;
    }

    @Override
    public Class<? extends Facet>[] getFacetTypes() {
        return new Class[]{NamedFacet.class, DescribedAsFacet.class, HelpFacet.class};
    }
}

