/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.actions.invoke.event;

import java.lang.reflect.Method;
import org.apache.isis.applib.FatalException;
import org.apache.isis.applib.Identifier;
import org.apache.isis.applib.services.eventbus.ActionInvokedEvent;
import org.apache.isis.applib.services.eventbus.EventBusService;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.adapter.util.AdapterUtils;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.ImperativeFacet;
import org.apache.isis.core.metamodel.facets.actions.event.PostsActionInvokedEventFacet;
import org.apache.isis.core.metamodel.runtimecontext.RuntimeContext;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjector;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.progmodel.facets.actions.invoke.ActionInvocationFacetViaMethod;

public class PostsActionInvokedEventFacetAnnotation
extends ActionInvocationFacetViaMethod
implements ImperativeFacet,
PostsActionInvokedEventFacet {
    private ServicesInjector servicesInjector;
    private Class<? extends ActionInvokedEvent<?>> eventType;
    private EventBusService eventBusService;
    private boolean searchedForEventBusService = false;

    public PostsActionInvokedEventFacetAnnotation(Method method, ObjectSpecification onType, ObjectSpecification returnType, FacetHolder holder, RuntimeContext runtimeContext, AdapterManager adapterManager, ServicesInjector servicesInjector, Class<? extends ActionInvokedEvent<?>> eventType) {
        super(method, onType, returnType, holder, runtimeContext, adapterManager, servicesInjector);
        this.servicesInjector = servicesInjector;
        this.eventType = eventType;
    }

    @Override
    public ObjectAdapter invoke(ObjectAction owningAction, ObjectAdapter targetAdapter, ObjectAdapter[] arguments) {
        ActionInvocationFacetViaMethod.InvocationResult invocationResult = this.internalInvoke(owningAction, targetAdapter, arguments);
        if (invocationResult.getWhetherInvoked()) {
            this.postEvent(owningAction, targetAdapter, arguments);
        }
        return invocationResult.getAdapter();
    }

    private void postEvent(ObjectAction owningAction, ObjectAdapter targetAdapter, ObjectAdapter[] argumentAdapters) {
        try {
            Class<? extends ActionInvokedEvent<?>> type = this.eventType;
            Identifier actionIdentifier = owningAction.getIdentifier();
            Object source = AdapterUtils.unwrap(targetAdapter);
            Object[] arguments = AdapterUtils.unwrap(argumentAdapters);
            ActionInvokedEvent<Object> event = PostsActionInvokedEventFacet.Util.newEvent(type, source, actionIdentifier, arguments);
            this.getEventBusService().post(event);
        }
        catch (Exception e) {
            throw new FatalException((Throwable)e);
        }
    }

    private EventBusService getEventBusService() {
        if (!this.searchedForEventBusService) {
            this.eventBusService = this.servicesInjector.lookupService(EventBusService.class);
        }
        this.searchedForEventBusService = true;
        return this.eventBusService;
    }
}

