/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.actions.invoke.event;

import java.lang.reflect.Method;
import org.apache.isis.applib.annotation.PostsActionInvokedEvent;
import org.apache.isis.core.commons.lang.StringExtensions;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManagerAware;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.named.NamedFacetInferred;
import org.apache.isis.core.metamodel.runtimecontext.RuntimeContext;
import org.apache.isis.core.metamodel.runtimecontext.RuntimeContextAware;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjector;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjectorAware;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.progmodel.facets.MethodPrefixBasedFacetFactoryAbstract;
import org.apache.isis.core.progmodel.facets.actions.invoke.DebugFacetViaNamingConvention;
import org.apache.isis.core.progmodel.facets.actions.invoke.ExplorationFacetViaNamingConvention;
import org.apache.isis.core.progmodel.facets.actions.invoke.event.PostsActionInvokedEventFacetAnnotation;

public class PostsActionInvokedEventFacetFactory
extends MethodPrefixBasedFacetFactoryAbstract
implements AdapterManagerAware,
ServicesInjectorAware,
RuntimeContextAware {
    private static final String EXPLORATION_PREFIX = "Exploration";
    private static final String DEBUG_PREFIX = "Debug";
    private static final String[] PREFIXES = new String[]{"Exploration", "Debug"};
    private AdapterManager adapterManager;
    private ServicesInjector servicesInjector;
    private RuntimeContext runtimeContext;

    public PostsActionInvokedEventFacetFactory() {
        super(FeatureType.ACTIONS_ONLY, MethodPrefixBasedFacetFactoryAbstract.OrphanValidation.VALIDATE, PREFIXES);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        this.attachInvocationFacet(processMethodContext);
        this.attachDebugFacetIfActionMethodNamePrefixed(processMethodContext);
        this.attachExplorationFacetIfActionMethodNamePrefixed(processMethodContext);
        this.attachNamedFacetInferredFromMethodName(processMethodContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attachInvocationFacet(FacetFactory.ProcessMethodContext processMethodContext) {
        Method actionMethod = processMethodContext.getMethod();
        try {
            PostsActionInvokedEvent annotation = Annotations.getAnnotation(actionMethod, PostsActionInvokedEvent.class);
            if (annotation == null) {
                return;
            }
            Class<?> returnType = actionMethod.getReturnType();
            ObjectSpecification returnSpec = this.getSpecificationLoader().loadSpecification(returnType);
            if (returnSpec == null) {
                return;
            }
            Class<?> cls = processMethodContext.getCls();
            ObjectSpecification typeSpec = this.getSpecificationLoader().loadSpecification(cls);
            Object holder = processMethodContext.getFacetHolder();
            Class changedEventType = annotation.value();
            FacetUtil.addFacet(new PostsActionInvokedEventFacetAnnotation(actionMethod, typeSpec, returnSpec, (FacetHolder)holder, this.getRuntimeContext(), this.getAdapterManager(), this.getServicesInjector(), changedEventType));
        }
        finally {
            processMethodContext.removeMethod(actionMethod);
        }
    }

    private void attachDebugFacetIfActionMethodNamePrefixed(FacetFactory.ProcessMethodContext processMethodContext) {
        Method actionMethod = processMethodContext.getMethod();
        String capitalizedName = StringExtensions.asCapitalizedName(actionMethod.getName());
        if (!capitalizedName.startsWith(DEBUG_PREFIX)) {
            return;
        }
        Object facetedMethod = processMethodContext.getFacetHolder();
        FacetUtil.addFacet(new DebugFacetViaNamingConvention((FacetHolder)facetedMethod));
    }

    private void attachExplorationFacetIfActionMethodNamePrefixed(FacetFactory.ProcessMethodContext processMethodContext) {
        Method actionMethod = processMethodContext.getMethod();
        String capitalizedName = StringExtensions.asCapitalizedName(actionMethod.getName());
        if (!capitalizedName.startsWith(EXPLORATION_PREFIX)) {
            return;
        }
        Object facetedMethod = processMethodContext.getFacetHolder();
        FacetUtil.addFacet(new ExplorationFacetViaNamingConvention((FacetHolder)facetedMethod));
    }

    private void attachNamedFacetInferredFromMethodName(FacetFactory.ProcessMethodContext processMethodContext) {
        String capitalizedName;
        Method method = processMethodContext.getMethod();
        String name = capitalizedName = StringExtensions.asCapitalizedName(method.getName());
        name = StringExtensions.removePrefix(name, DEBUG_PREFIX);
        name = StringExtensions.removePrefix(name, EXPLORATION_PREFIX);
        name = StringExtensions.asNaturalName2(name);
        Object facetedMethod = processMethodContext.getFacetHolder();
        FacetUtil.addFacet(new NamedFacetInferred(name, (FacetHolder)facetedMethod));
    }

    @Override
    public void setAdapterManager(AdapterManager adapterManager) {
        this.adapterManager = adapterManager;
    }

    private AdapterManager getAdapterManager() {
        return this.adapterManager;
    }

    @Override
    public void setServicesInjector(ServicesInjector servicesInjector) {
        this.servicesInjector = servicesInjector;
    }

    private ServicesInjector getServicesInjector() {
        return this.servicesInjector;
    }

    private RuntimeContext getRuntimeContext() {
        return this.runtimeContext;
    }

    @Override
    public void setRuntimeContext(RuntimeContext runtimeContext) {
        this.runtimeContext = runtimeContext;
    }
}

