/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.collections.clear;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.ObjectDirtier;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.adapter.util.AdapterInvokeUtils;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.ImperativeFacet;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionClearFacetAbstract;

public class CollectionClearFacetViaAccessor
extends CollectionClearFacetAbstract
implements ImperativeFacet {
    private final Method method;
    private final AdapterManager adapterManager;
    private final ObjectDirtier objectDirtier;

    public CollectionClearFacetViaAccessor(Method method, FacetHolder holder, AdapterManager adapterManager, ObjectDirtier objectDirtier) {
        super(holder);
        this.method = method;
        this.adapterManager = adapterManager;
        this.objectDirtier = objectDirtier;
    }

    @Override
    public List<Method> getMethods() {
        return Collections.singletonList(this.method);
    }

    @Override
    public ImperativeFacet.Intent getIntent(Method method) {
        return ImperativeFacet.Intent.ACCESSOR;
    }

    @Override
    public boolean impliesResolve() {
        return true;
    }

    @Override
    public boolean impliesObjectChanged() {
        return false;
    }

    @Override
    public void clear(ObjectAdapter owningAdapter) {
        Collection collection = (Collection)AdapterInvokeUtils.invoke(this.method, owningAdapter);
        collection.clear();
        ObjectAdapter adapter = this.getAdapterManager().getAdapterFor(owningAdapter);
        this.getObjectDirtier().objectChanged(adapter);
    }

    @Override
    protected String toStringValues() {
        return "method=" + this.method;
    }

    protected AdapterManager getAdapterManager() {
        return this.adapterManager;
    }

    protected ObjectDirtier getObjectDirtier() {
        return this.objectDirtier;
    }
}

