/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.collections.clear;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.util.AdapterInvokeUtils;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.ImperativeFacet;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionClearFacetAbstract;

public class CollectionClearFacetViaMethod
extends CollectionClearFacetAbstract
implements ImperativeFacet {
    private final Method method;

    public CollectionClearFacetViaMethod(Method method, FacetHolder holder) {
        super(holder);
        this.method = method;
    }

    @Override
    public List<Method> getMethods() {
        return Collections.singletonList(this.method);
    }

    @Override
    public ImperativeFacet.Intent getIntent(Method method) {
        return ImperativeFacet.Intent.MODIFY_COLLECTION_ADD;
    }

    @Override
    public boolean impliesResolve() {
        return true;
    }

    @Override
    public boolean impliesObjectChanged() {
        return true;
    }

    @Override
    public void clear(ObjectAdapter owningAdapter) {
        AdapterInvokeUtils.invoke(this.method, owningAdapter);
    }

    @Override
    protected String toStringValues() {
        return "method=" + this.method;
    }
}

