/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.collections.event;

import com.google.common.collect.Lists;
import java.util.Set;
import org.apache.isis.applib.FatalException;
import org.apache.isis.applib.Identifier;
import org.apache.isis.applib.services.eventbus.CollectionAddedToEvent;
import org.apache.isis.applib.services.eventbus.EventBusService;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.util.AdapterUtils;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.accessor.PropertyOrCollectionAccessorFacet;
import org.apache.isis.core.metamodel.facets.collections.event.PostsCollectionAddedToEventFacet;
import org.apache.isis.core.metamodel.facets.collections.event.PostsCollectionAddedToEventFacetAbstract;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionAddToFacet;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjector;

public class PostsCollectionAddedToEventFacetAnnotation
extends PostsCollectionAddedToEventFacetAbstract {
    private final PropertyOrCollectionAccessorFacet getterFacet;
    private final CollectionAddToFacet collectionAddToFacet;
    private final ServicesInjector servicesInjector;
    private EventBusService eventBusService;
    private boolean searchedForEventBusService = false;

    public PostsCollectionAddedToEventFacetAnnotation(Class<? extends CollectionAddedToEvent<?, ?>> eventType, PropertyOrCollectionAccessorFacet getterFacet, CollectionAddToFacet collectionAddToFacet, ServicesInjector servicesInjector, FacetHolder holder) {
        super(eventType, holder);
        this.getterFacet = getterFacet;
        this.collectionAddToFacet = collectionAddToFacet;
        this.servicesInjector = servicesInjector;
    }

    @Override
    public void add(ObjectAdapter targetAdapter, ObjectAdapter referencedObjectAdapter) {
        Set set;
        if (this.collectionAddToFacet == null) {
            return;
        }
        this.eventBusService = this.getEventBusService();
        if (this.eventBusService == null) {
            this.collectionAddToFacet.add(targetAdapter, referencedObjectAdapter);
            return;
        }
        Object referencedObject = AdapterUtils.unwrap(referencedObjectAdapter);
        Object collection = this.getterFacet.getProperty(targetAdapter);
        if (collection instanceof Set && (set = (Set)collection).contains(referencedObject)) {
            return;
        }
        this.collectionAddToFacet.add(targetAdapter, referencedObjectAdapter);
        this.postEvent(targetAdapter, this.getIdentified().getIdentifier(), referencedObject);
    }

    private void postEvent(ObjectAdapter targetAdapter, Identifier identifier, Object addedReference) {
        try {
            Class type = (Class)this.value();
            Object source = AdapterUtils.unwrap(targetAdapter);
            CollectionAddedToEvent<Object, Object> event = PostsCollectionAddedToEventFacet.Util.newEvent(type, source, identifier, addedReference);
            this.eventBusService.post(event);
        }
        catch (Exception e) {
            throw new FatalException((Throwable)e);
        }
    }

    private EventBusService getEventBusService() {
        if (!this.searchedForEventBusService) {
            this.eventBusService = this.servicesInjector.lookupService(EventBusService.class);
        }
        this.searchedForEventBusService = true;
        return this.eventBusService;
    }

    @Override
    public Class<? extends Facet>[] facetTypes() {
        return Lists.newArrayList((Object[])new Class[]{PostsCollectionAddedToEventFacetAnnotation.type(), PostsCollectionAddedToEventFacet.class}).toArray(new Class[0]);
    }

    @Override
    public <T extends Facet> T getFacet(Class<T> facet) {
        return (T)this;
    }
}

