/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.collections.event;

import com.google.common.collect.Lists;
import java.util.Collection;
import org.apache.isis.applib.FatalException;
import org.apache.isis.applib.Identifier;
import org.apache.isis.applib.services.eventbus.CollectionRemovedFromEvent;
import org.apache.isis.applib.services.eventbus.EventBusService;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.util.AdapterUtils;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.accessor.PropertyOrCollectionAccessorFacet;
import org.apache.isis.core.metamodel.facets.collections.event.PostsCollectionRemovedFromEventFacet;
import org.apache.isis.core.metamodel.facets.collections.event.PostsCollectionRemovedFromEventFacetAbstract;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionRemoveFromFacet;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjector;

public class PostsCollectionRemovedFromEventFacetAnnotation
extends PostsCollectionRemovedFromEventFacetAbstract {
    private final PropertyOrCollectionAccessorFacet getterFacet;
    private final CollectionRemoveFromFacet collectionRemoveFromFacet;
    private final ServicesInjector servicesInjector;
    private EventBusService eventBusService;
    private boolean searchedForEventBusService = false;

    public PostsCollectionRemovedFromEventFacetAnnotation(Class<? extends CollectionRemovedFromEvent<?, ?>> eventType, PropertyOrCollectionAccessorFacet getterFacet, CollectionRemoveFromFacet collectionRemoveFromFacet, ServicesInjector servicesInjector, FacetHolder holder) {
        super(eventType, holder);
        this.getterFacet = getterFacet;
        this.collectionRemoveFromFacet = collectionRemoveFromFacet;
        this.servicesInjector = servicesInjector;
    }

    @Override
    public void remove(ObjectAdapter targetAdapter, ObjectAdapter referencedObjectAdapter) {
        if (this.collectionRemoveFromFacet == null) {
            return;
        }
        this.eventBusService = this.getEventBusService();
        if (this.eventBusService == null) {
            this.collectionRemoveFromFacet.remove(targetAdapter, referencedObjectAdapter);
            return;
        }
        Object referencedObject = AdapterUtils.unwrap(referencedObjectAdapter);
        Object collection = this.getterFacet.getProperty(targetAdapter);
        if (!((Collection)collection).contains(referencedObject)) {
            return;
        }
        this.collectionRemoveFromFacet.remove(targetAdapter, referencedObjectAdapter);
        this.postEvent(targetAdapter, this.getIdentified().getIdentifier(), referencedObject);
    }

    private void postEvent(ObjectAdapter targetAdapter, Identifier identifier, Object removedReference) {
        try {
            Class type = (Class)this.value();
            Object source = AdapterUtils.unwrap(targetAdapter);
            CollectionRemovedFromEvent<Object, Object> event = PostsCollectionRemovedFromEventFacet.Util.newEvent(type, source, identifier, removedReference);
            this.eventBusService.post(event);
        }
        catch (Exception e) {
            throw new FatalException((Throwable)e);
        }
    }

    private EventBusService getEventBusService() {
        if (!this.searchedForEventBusService) {
            this.eventBusService = this.servicesInjector.lookupService(EventBusService.class);
        }
        this.searchedForEventBusService = true;
        return this.eventBusService;
    }

    @Override
    public Class<? extends Facet>[] facetTypes() {
        return Lists.newArrayList((Object[])new Class[]{PostsCollectionRemovedFromEventFacetAnnotation.type(), PostsCollectionRemovedFromEventFacet.class}).toArray(new Class[0]);
    }

    @Override
    public <T extends Facet> T getFacet(Class<T> facet) {
        return (T)this;
    }
}

