/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.collections.modify;

import java.lang.reflect.Method;
import org.apache.isis.core.commons.lang.StringExtensions;
import org.apache.isis.core.metamodel.adapter.ObjectDirtier;
import org.apache.isis.core.metamodel.adapter.ObjectDirtierAware;
import org.apache.isis.core.metamodel.exceptions.MetaModelException;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionAddToFacet;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionRemoveFromFacet;
import org.apache.isis.core.metamodel.methodutils.MethodScope;
import org.apache.isis.core.progmodel.facets.MethodFinderUtils;
import org.apache.isis.core.progmodel.facets.MethodPrefixBasedFacetFactoryAbstract;
import org.apache.isis.core.progmodel.facets.MethodPrefixConstants;
import org.apache.isis.core.progmodel.facets.collections.modify.CollectionAddToFacetViaAccessor;
import org.apache.isis.core.progmodel.facets.collections.modify.CollectionAddToFacetViaMethod;
import org.apache.isis.core.progmodel.facets.collections.modify.CollectionRemoveFromFacetViaAccessor;
import org.apache.isis.core.progmodel.facets.collections.modify.CollectionRemoveFromFacetViaMethod;
import org.apache.isis.core.progmodel.facets.collections.modify.TypeOfFacetInferredFromSupportingMethods;
import org.apache.isis.core.progmodel.facets.collections.validate.CollectionValidateAddToFacetViaMethod;
import org.apache.isis.core.progmodel.facets.collections.validate.CollectionValidateRemoveFromFacetViaMethod;

public class CollectionAddRemoveAndValidateFacetFactory
extends MethodPrefixBasedFacetFactoryAbstract
implements ObjectDirtierAware {
    private static final String[] PREFIXES = new String[0];
    private ObjectDirtier objectDirtier;

    public CollectionAddRemoveAndValidateFacetFactory() {
        super(FeatureType.COLLECTIONS_ONLY, MethodPrefixBasedFacetFactoryAbstract.OrphanValidation.VALIDATE, PREFIXES);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        Class<?> collectionType = this.attachAddToFacetAndRemoveFromFacet(processMethodContext);
        this.attachValidateAddToAndRemoveFromFacetIfMethodsFound(processMethodContext, collectionType);
    }

    private Class<?> attachAddToFacetAndRemoveFromFacet(FacetFactory.ProcessMethodContext processMethodContext) {
        Method accessorMethod = processMethodContext.getMethod();
        String capitalizedName = StringExtensions.asJavaBaseName(accessorMethod.getName());
        Class<?> cls = processMethodContext.getCls();
        Method addToMethod = MethodFinderUtils.findMethod(cls, MethodScope.OBJECT, "addTo" + capitalizedName, Void.TYPE);
        processMethodContext.removeMethod(addToMethod);
        Method removeFromMethod = MethodFinderUtils.findMethod(cls, MethodScope.OBJECT, "removeFrom" + capitalizedName, Void.TYPE);
        processMethodContext.removeMethod(removeFromMethod);
        Object collection = processMethodContext.getFacetHolder();
        FacetUtil.addFacet(this.createAddToFacet(addToMethod, accessorMethod, (FacetHolder)collection));
        FacetUtil.addFacet(this.createRemoveFromFacet(removeFromMethod, accessorMethod, (FacetHolder)collection));
        Class<?> addToType = addToMethod == null || addToMethod.getParameterTypes().length != 1 ? null : addToMethod.getParameterTypes()[0];
        Class<?> removeFromType = removeFromMethod == null || removeFromMethod.getParameterTypes().length != 1 ? null : removeFromMethod.getParameterTypes()[0];
        return this.inferTypeOfIfPossible(accessorMethod, addToType, removeFromType, (FacetHolder)collection);
    }

    private CollectionAddToFacet createAddToFacet(Method addToMethodIfAny, Method accessorMethod, FacetHolder holder) {
        if (addToMethodIfAny != null) {
            return new CollectionAddToFacetViaMethod(addToMethodIfAny, holder);
        }
        return new CollectionAddToFacetViaAccessor(accessorMethod, holder, this.getObjectDirtier());
    }

    private CollectionRemoveFromFacet createRemoveFromFacet(Method removeFromMethodIfAny, Method accessorMethod, FacetHolder holder) {
        if (removeFromMethodIfAny != null) {
            return new CollectionRemoveFromFacetViaMethod(removeFromMethodIfAny, holder);
        }
        return new CollectionRemoveFromFacetViaAccessor(accessorMethod, holder, this.getObjectDirtier());
    }

    private Class<?> inferTypeOfIfPossible(Method getMethod, Class<?> addType, Class<?> removeType, FacetHolder collection) {
        Class<?> type;
        if (addType != null && removeType != null && addType != removeType) {
            throw new MetaModelException("The addTo/removeFrom methods for " + getMethod.getDeclaringClass() + " must " + "both deal with same type of object: " + addType + "; " + removeType);
        }
        Class<?> clazz = type = addType != null ? addType : removeType;
        if (type != null) {
            FacetUtil.addFacet(new TypeOfFacetInferredFromSupportingMethods(type, collection, this.getSpecificationLoader()));
        }
        return type;
    }

    private void attachValidateAddToAndRemoveFromFacetIfMethodsFound(FacetFactory.ProcessMethodContext processMethodContext, Class<?> collectionType) {
        this.attachValidateAddToFacetIfValidateAddToMethodIsFound(processMethodContext, collectionType);
        this.attachValidateRemoveFacetIfValidateRemoveFromMethodIsFound(processMethodContext, collectionType);
    }

    private void attachValidateAddToFacetIfValidateAddToMethodIsFound(FacetFactory.ProcessMethodContext processMethodContext, Class<?> collectionType) {
        Method getMethod = processMethodContext.getMethod();
        String capitalizedName = StringExtensions.asJavaBaseName(getMethod.getName());
        Class<?> cls = processMethodContext.getCls();
        Class<?>[] paramTypes = MethodFinderUtils.paramTypesOrNull(collectionType);
        Method validateAddToMethod = MethodFinderUtils.findMethod(cls, MethodScope.OBJECT, "validateaddTo" + capitalizedName, String.class, paramTypes);
        if (validateAddToMethod == null) {
            validateAddToMethod = MethodFinderUtils.findMethod(cls, MethodScope.OBJECT, MethodPrefixConstants.VALIDATE_ADD_TO_PREFIX_2 + capitalizedName, String.class, MethodFinderUtils.paramTypesOrNull(collectionType));
        }
        if (validateAddToMethod == null) {
            return;
        }
        processMethodContext.removeMethod(validateAddToMethod);
        Object collection = processMethodContext.getFacetHolder();
        FacetUtil.addFacet(new CollectionValidateAddToFacetViaMethod(validateAddToMethod, (FacetHolder)collection));
    }

    private void attachValidateRemoveFacetIfValidateRemoveFromMethodIsFound(FacetFactory.ProcessMethodContext processMethodContext, Class<?> collectionType) {
        Method getMethod = processMethodContext.getMethod();
        String capitalizedName = StringExtensions.asJavaBaseName(getMethod.getName());
        Class<?> cls = processMethodContext.getCls();
        Class<?>[] paramTypes = MethodFinderUtils.paramTypesOrNull(collectionType);
        Method validateRemoveFromMethod = MethodFinderUtils.findMethod(cls, MethodScope.OBJECT, "validateremoveFrom" + capitalizedName, String.class, paramTypes);
        if (validateRemoveFromMethod == null) {
            validateRemoveFromMethod = MethodFinderUtils.findMethod(cls, MethodScope.OBJECT, MethodPrefixConstants.VALIDATE_REMOVE_FROM_PREFIX_2 + capitalizedName, String.class, MethodFinderUtils.paramTypesOrNull(collectionType));
        }
        if (validateRemoveFromMethod == null) {
            return;
        }
        processMethodContext.removeMethod(validateRemoveFromMethod);
        Object collection = processMethodContext.getFacetHolder();
        FacetUtil.addFacet(new CollectionValidateRemoveFromFacetViaMethod(validateRemoveFromMethod, (FacetHolder)collection));
    }

    protected ObjectDirtier getObjectDirtier() {
        return this.objectDirtier;
    }

    @Override
    public void setObjectDirtier(ObjectDirtier objectDirtier) {
        this.objectDirtier = objectDirtier;
    }
}

