/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.collections.modify;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.ObjectDirtier;
import org.apache.isis.core.metamodel.adapter.util.AdapterInvokeUtils;
import org.apache.isis.core.metamodel.adapter.util.AdapterUtils;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.ImperativeFacet;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionAddToFacetAbstract;

public class CollectionAddToFacetViaAccessor
extends CollectionAddToFacetAbstract
implements ImperativeFacet {
    private final Method method;
    private final ObjectDirtier objectDirtier;

    public CollectionAddToFacetViaAccessor(Method method, FacetHolder holder, ObjectDirtier objectDirtier) {
        super(holder);
        this.method = method;
        this.objectDirtier = objectDirtier;
    }

    @Override
    public List<Method> getMethods() {
        return Collections.singletonList(this.method);
    }

    @Override
    public ImperativeFacet.Intent getIntent(Method method) {
        return ImperativeFacet.Intent.MODIFY_COLLECTION_ADD;
    }

    @Override
    public boolean impliesResolve() {
        return true;
    }

    @Override
    public boolean impliesObjectChanged() {
        return false;
    }

    @Override
    public void add(ObjectAdapter owningAdapter, ObjectAdapter elementAdapter) {
        Collection collection = (Collection)AdapterInvokeUtils.invoke(this.method, owningAdapter);
        Object elementPojo = AdapterUtils.unwrap(elementAdapter);
        collection.add(elementPojo);
        this.getObjectDirtier().objectChanged(owningAdapter);
    }

    @Override
    protected String toStringValues() {
        return "method=" + this.method;
    }

    protected ObjectDirtier getObjectDirtier() {
        return this.objectDirtier;
    }
}

