/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.members.cssclass;

import java.util.Properties;
import org.apache.isis.applib.annotation.CssClass;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.ContributeeMemberFacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.members.cssclass.CssClassFacet;
import org.apache.isis.core.progmodel.facets.members.cssclass.CssClassFacetOnMemberAnnotation;
import org.apache.isis.core.progmodel.facets.members.cssclass.CssClassFacetOnMemberFromProperties;

public class CssClassOnMemberFacetFactory
extends FacetFactoryAbstract
implements ContributeeMemberFacetFactory {
    public CssClassOnMemberFacetFactory() {
        super(FeatureType.MEMBERS);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        CssClassFacet cssClassFacet = CssClassOnMemberFacetFactory.createFromMetadataPropertiesIfPossible(processMethodContext);
        if (cssClassFacet == null) {
            cssClassFacet = this.createFromAnnotationIfPossible(processMethodContext);
        }
        FacetUtil.addFacet(cssClassFacet);
    }

    @Override
    public void process(ContributeeMemberFacetFactory.ProcessContributeeMemberContext processMemberContext) {
        CssClassFacet cssClassFacet = CssClassOnMemberFacetFactory.createFromMetadataPropertiesIfPossible(processMemberContext);
        FacetUtil.addFacet(cssClassFacet);
    }

    private static CssClassFacet createFromMetadataPropertiesIfPossible(FacetFactory.ProcessContextWithMetadataProperties<? extends FacetHolder> pcwmp) {
        FacetHolder holder = pcwmp.getFacetHolder();
        Properties properties = pcwmp.metadataProperties("cssClass");
        return properties != null ? new CssClassFacetOnMemberFromProperties(properties, holder) : null;
    }

    private CssClassFacet createFromAnnotationIfPossible(FacetFactory.ProcessMethodContext processMethodContext) {
        CssClass annotation = Annotations.getAnnotation(processMethodContext.getMethod(), CssClass.class);
        return annotation != null ? new CssClassFacetOnMemberAnnotation(annotation.value(), (FacetHolder)processMethodContext.getFacetHolder()) : null;
    }
}

