/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.members.disabled.forsession;

import java.lang.reflect.Method;
import org.apache.isis.applib.security.UserMemento;
import org.apache.isis.core.commons.lang.StringExtensions;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.methodutils.MethodScope;
import org.apache.isis.core.progmodel.facets.MethodFinderUtils;
import org.apache.isis.core.progmodel.facets.MethodPrefixBasedFacetFactoryAbstract;
import org.apache.isis.core.progmodel.facets.members.disabled.forsession.DisableForSessionFacetViaMethod;

public class DisabledFacetViaDisableForSessionMethodFacetFactory
extends MethodPrefixBasedFacetFactoryAbstract {
    private static final String[] PREFIXES = new String[]{"disable"};

    public DisabledFacetViaDisableForSessionMethodFacetFactory() {
        super(FeatureType.MEMBERS, MethodPrefixBasedFacetFactoryAbstract.OrphanValidation.VALIDATE, PREFIXES);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        DisabledFacetViaDisableForSessionMethodFacetFactory.attachDisableFacetIfDisableMethodForSessionIsFound(processMethodContext);
    }

    public static void attachDisableFacetIfDisableMethodForSessionIsFound(FacetFactory.ProcessMethodContext processMethodContext) {
        Method method = processMethodContext.getMethod();
        String capitalizedName = StringExtensions.asJavaBaseNameStripAccessorPrefixIfRequired(method.getName());
        Class<?> cls = processMethodContext.getCls();
        Method disableForSessionMethod = MethodFinderUtils.findMethod(cls, MethodScope.CLASS, "disable" + capitalizedName, String.class, new Class[]{UserMemento.class});
        if (disableForSessionMethod == null) {
            return;
        }
        processMethodContext.removeMethod(disableForSessionMethod);
        Object facetedMethod = processMethodContext.getFacetHolder();
        FacetUtil.addFacet(new DisableForSessionFacetViaMethod(disableForSessionMethod, (FacetHolder)facetedMethod));
    }
}

