/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.members.disabled.method;

import java.lang.reflect.Method;
import org.apache.isis.core.commons.lang.StringExtensions;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.methodutils.MethodScope;
import org.apache.isis.core.progmodel.facets.MethodFinderUtils;
import org.apache.isis.core.progmodel.facets.MethodPrefixBasedFacetFactoryAbstract;
import org.apache.isis.core.progmodel.facets.members.disabled.method.DisableForContextFacetViaMethod;

public class DisabledFacetViaDisableMethodFacetFactory
extends MethodPrefixBasedFacetFactoryAbstract {
    private static final String[] PREFIXES = new String[]{"disable"};

    public DisabledFacetViaDisableMethodFacetFactory() {
        super(FeatureType.MEMBERS, MethodPrefixBasedFacetFactoryAbstract.OrphanValidation.VALIDATE, PREFIXES);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        DisabledFacetViaDisableMethodFacetFactory.attachDisabledFacetIfDisabledMethodIsFound(processMethodContext);
    }

    public static void attachDisabledFacetIfDisabledMethodIsFound(FacetFactory.ProcessMethodContext processMethodContext) {
        Method method = processMethodContext.getMethod();
        String capitalizedName = StringExtensions.asJavaBaseNameStripAccessorPrefixIfRequired(method.getName());
        Class<?> cls = processMethodContext.getCls();
        Method disableMethod = MethodFinderUtils.findMethod(cls, MethodScope.OBJECT, "disable" + capitalizedName, String.class, method.getParameterTypes());
        if (disableMethod == null) {
            return;
        }
        processMethodContext.removeMethod(disableMethod);
        Object facetHolder = processMethodContext.getFacetHolder();
        FacetUtil.addFacet(new DisableForContextFacetViaMethod(disableMethod, (FacetHolder)facetHolder));
    }
}

