/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.members.hidden.annotation;

import java.util.Properties;
import org.apache.isis.applib.annotation.Hidden;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.ContributeeMemberFacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.hide.HiddenFacet;
import org.apache.isis.core.progmodel.facets.members.hidden.annotation.HiddenFacetOnMemberAnnotation;
import org.apache.isis.core.progmodel.facets.members.hidden.annotation.HiddenFacetOnMemberFromProperties;

public class HiddenForMemberFacetFactory
extends FacetFactoryAbstract
implements ContributeeMemberFacetFactory {
    public HiddenForMemberFacetFactory() {
        super(FeatureType.MEMBERS);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        HiddenFacet hiddenFacet = HiddenForMemberFacetFactory.createFromMetadataPropertiesIfPossible(processMethodContext);
        if (hiddenFacet == null) {
            hiddenFacet = HiddenForMemberFacetFactory.createFromAnnotationIfPossible(processMethodContext);
        }
        FacetUtil.addFacet(hiddenFacet);
    }

    @Override
    public void process(ContributeeMemberFacetFactory.ProcessContributeeMemberContext processMemberContext) {
        HiddenFacet hiddenFacet = HiddenForMemberFacetFactory.createFromMetadataPropertiesIfPossible(processMemberContext);
        FacetUtil.addFacet(hiddenFacet);
    }

    private static HiddenFacet createFromAnnotationIfPossible(FacetFactory.ProcessMethodContext processMethodContext) {
        Hidden hiddenAnnotation = Annotations.getAnnotation(processMethodContext.getMethod(), Hidden.class);
        return hiddenAnnotation != null ? new HiddenFacetOnMemberAnnotation(hiddenAnnotation.when(), hiddenAnnotation.where(), (FacetHolder)processMethodContext.getFacetHolder()) : null;
    }

    private static HiddenFacet createFromMetadataPropertiesIfPossible(FacetFactory.ProcessContextWithMetadataProperties<? extends FacetHolder> pcwmp) {
        FacetHolder holder = pcwmp.getFacetHolder();
        Properties properties = pcwmp.metadataProperties("hidden");
        return properties != null ? new HiddenFacetOnMemberFromProperties(properties, holder) : null;
    }
}

