/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.members.hidden.forsession;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.authentication.AuthenticationSessionUtils;
import org.apache.isis.core.commons.lang.MethodExtensions;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.ImperativeFacet;
import org.apache.isis.core.progmodel.facets.members.hidden.HideForSessionFacetAbstract;

public class HideForSessionFacetViaMethod
extends HideForSessionFacetAbstract
implements ImperativeFacet {
    private final Method method;

    public HideForSessionFacetViaMethod(Method method, FacetHolder holder) {
        super(holder);
        this.method = method;
    }

    @Override
    public List<Method> getMethods() {
        return Collections.singletonList(this.method);
    }

    @Override
    public ImperativeFacet.Intent getIntent(Method method) {
        return ImperativeFacet.Intent.CHECK_IF_HIDDEN;
    }

    @Override
    public boolean impliesResolve() {
        return true;
    }

    @Override
    public boolean impliesObjectChanged() {
        return false;
    }

    @Override
    public String hiddenReason(AuthenticationSession session) {
        if (session == null) {
            return null;
        }
        int len = this.method.getParameterTypes().length;
        Object[] parameters = new Object[len];
        parameters[0] = AuthenticationSessionUtils.createUserMemento(session);
        Boolean isHidden = (Boolean)MethodExtensions.invokeStatic(this.method, parameters);
        return isHidden != false ? "Hidden" : null;
    }

    @Override
    protected String toStringValues() {
        return "method=" + this.method;
    }
}

