/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.members.hidden.method;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import org.apache.isis.applib.events.VisibilityEvent;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.util.AdapterInvokeUtils;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.ImperativeFacet;
import org.apache.isis.core.metamodel.interactions.VisibilityContext;
import org.apache.isis.core.progmodel.facets.members.hidden.HideForContextFacetAbstract;

public class HideForContextFacetViaMethod
extends HideForContextFacetAbstract
implements ImperativeFacet {
    private final Method method;

    public HideForContextFacetViaMethod(Method method, FacetHolder holder) {
        super(holder);
        this.method = method;
    }

    @Override
    public List<Method> getMethods() {
        return Collections.singletonList(this.method);
    }

    @Override
    public ImperativeFacet.Intent getIntent(Method method) {
        return ImperativeFacet.Intent.CHECK_IF_HIDDEN;
    }

    @Override
    public boolean impliesResolve() {
        return true;
    }

    @Override
    public boolean impliesObjectChanged() {
        return false;
    }

    @Override
    public String hides(VisibilityContext<? extends VisibilityEvent> ic) {
        ObjectAdapter target = ic.getTarget();
        if (target == null) {
            return null;
        }
        Boolean isHidden = (Boolean)AdapterInvokeUtils.invoke(this.method, target, ic.getContributeeAsMap());
        return isHidden != false ? "Hidden" : null;
    }

    @Override
    protected String toStringValues() {
        return "method=" + this.method;
    }
}

