/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.members.hidden.staticmethod;

import java.lang.reflect.Method;
import org.apache.isis.core.commons.lang.MethodExtensions;
import org.apache.isis.core.commons.lang.StringExtensions;
import org.apache.isis.core.metamodel.exceptions.MetaModelException;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.methodutils.MethodScope;
import org.apache.isis.core.progmodel.facets.MethodFinderUtils;
import org.apache.isis.core.progmodel.facets.MethodPrefixBasedFacetFactoryAbstract;
import org.apache.isis.core.progmodel.facets.members.hidden.staticmethod.HiddenFacetAlwaysEverywhere;

public class HiddenFacetViaAlwaysHideMethodFacetFactory
extends MethodPrefixBasedFacetFactoryAbstract {
    private static final String[] PREFIXES = new String[]{"hide"};

    public HiddenFacetViaAlwaysHideMethodFacetFactory() {
        super(FeatureType.MEMBERS, MethodPrefixBasedFacetFactoryAbstract.OrphanValidation.VALIDATE, PREFIXES);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        HiddenFacetViaAlwaysHideMethodFacetFactory.attachHiddenFacetIfAlwaysHideMethodIsFound(processMethodContext);
    }

    public static void attachHiddenFacetIfAlwaysHideMethodIsFound(FacetFactory.ProcessMethodContext processMethodContext) {
        Class<?> type = processMethodContext.getCls();
        Method method = processMethodContext.getMethod();
        String capitalizedName = StringExtensions.asJavaBaseNameStripAccessorPrefixIfRequired(method.getName());
        Method alwaysHideMethod = MethodFinderUtils.findMethod(type, MethodScope.CLASS, "alwaysHide" + capitalizedName, Boolean.TYPE, new Class[0]);
        if (alwaysHideMethod == null) {
            return;
        }
        processMethodContext.removeMethod(alwaysHideMethod);
        Boolean alwaysHideMethodReturnValue = HiddenFacetViaAlwaysHideMethodFacetFactory.invokeAlwaysHideMethod(alwaysHideMethod);
        if (!alwaysHideMethodReturnValue.booleanValue()) {
            return;
        }
        Object facetedMethod = processMethodContext.getFacetHolder();
        FacetUtil.addFacet(new HiddenFacetAlwaysEverywhere((FacetHolder)facetedMethod));
    }

    private static Boolean invokeAlwaysHideMethod(Method alwaysHideMethod) {
        Boolean alwaysHideMethodReturnValue = null;
        try {
            alwaysHideMethodReturnValue = (Boolean)MethodExtensions.invokeStatic(alwaysHideMethod);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (alwaysHideMethodReturnValue == null) {
            throw new MetaModelException("method " + alwaysHideMethod + "must return a boolean");
        }
        return alwaysHideMethodReturnValue;
    }
}

