/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.members.named.staticmethod;

import java.lang.reflect.Method;
import org.apache.isis.core.commons.lang.MethodExtensions;
import org.apache.isis.core.commons.lang.StringExtensions;
import org.apache.isis.core.metamodel.exceptions.MetaModelException;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.methodutils.MethodScope;
import org.apache.isis.core.progmodel.facets.MethodFinderUtils;
import org.apache.isis.core.progmodel.facets.MethodPrefixBasedFacetFactoryAbstract;
import org.apache.isis.core.progmodel.facets.members.named.staticmethod.NamedFacetViaMethod;

public class NamedFacetViaNameMethodFacetFactory
extends MethodPrefixBasedFacetFactoryAbstract {
    private static final String[] PREFIXES = new String[]{"name"};

    public NamedFacetViaNameMethodFacetFactory() {
        super(FeatureType.MEMBERS, MethodPrefixBasedFacetFactoryAbstract.OrphanValidation.VALIDATE, PREFIXES);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        NamedFacetViaNameMethodFacetFactory.attachNamedFacetIfNamedMethodIsFound(processMethodContext);
    }

    public static void attachNamedFacetIfNamedMethodIsFound(FacetFactory.ProcessMethodContext processMethodContext) {
        Method method = processMethodContext.getMethod();
        String capitalizedName = StringExtensions.asJavaBaseNameStripAccessorPrefixIfRequired(method.getName());
        Class<?> cls = processMethodContext.getCls();
        Method nameMethod = MethodFinderUtils.findMethod(cls, MethodScope.CLASS, "name" + capitalizedName, String.class, new Class[0]);
        if (nameMethod == null) {
            return;
        }
        processMethodContext.removeMethod(nameMethod);
        String name = NamedFacetViaNameMethodFacetFactory.invokeNameMethod(nameMethod);
        Object facetHolder = processMethodContext.getFacetHolder();
        FacetUtil.addFacet(new NamedFacetViaMethod(name, nameMethod, (FacetHolder)facetHolder));
    }

    private static String invokeNameMethod(Method nameMethod) {
        String name = null;
        try {
            name = (String)MethodExtensions.invokeStatic(nameMethod);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (name == null) {
            throw new MetaModelException("method " + nameMethod + "must return a string");
        }
        return name;
    }
}

