/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.members.order;

import java.util.Properties;
import org.apache.isis.applib.annotation.MemberOrder;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.ContributeeMemberFacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.members.order.MemberOrderFacet;
import org.apache.isis.core.progmodel.facets.members.order.MemberOrderFacetAnnotation;
import org.apache.isis.core.progmodel.facets.members.order.MemberOrderFacetProperties;

public class MemberOrderFacetFactory
extends FacetFactoryAbstract
implements ContributeeMemberFacetFactory {
    public MemberOrderFacetFactory() {
        super(FeatureType.MEMBERS);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        MemberOrderFacet memberOrderFacet = MemberOrderFacetFactory.createFromMetadataPropertiesIfPossible(processMethodContext);
        if (memberOrderFacet == null) {
            memberOrderFacet = MemberOrderFacetFactory.createFromAnnotationIfPossible(processMethodContext);
        }
        FacetUtil.addFacet(memberOrderFacet);
    }

    @Override
    public void process(ContributeeMemberFacetFactory.ProcessContributeeMemberContext processMemberContext) {
        MemberOrderFacet memberOrderFacet = MemberOrderFacetFactory.createFromMetadataPropertiesIfPossible(processMemberContext);
        FacetUtil.addFacet(memberOrderFacet);
    }

    private static MemberOrderFacet createFromMetadataPropertiesIfPossible(FacetFactory.ProcessContextWithMetadataProperties<? extends FacetHolder> pcwmp) {
        FacetHolder holder = pcwmp.getFacetHolder();
        Properties properties = pcwmp.metadataProperties("memberOrder");
        MemberOrderFacetProperties memberOrderFacet = properties != null ? new MemberOrderFacetProperties(properties, holder) : null;
        return memberOrderFacet;
    }

    private static MemberOrderFacet createFromAnnotationIfPossible(FacetFactory.ProcessMethodContext processMethodContext) {
        MemberOrder annotation = Annotations.getAnnotation(processMethodContext.getMethod(), MemberOrder.class);
        return annotation != null ? new MemberOrderFacetAnnotation(annotation.name(), annotation.sequence(), (FacetHolder)processMethodContext.getFacetHolder()) : null;
    }
}

