/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.members.resolve;

import java.util.Properties;
import org.apache.isis.applib.annotation.Render;
import org.apache.isis.applib.annotation.Resolve;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.ContributeeMemberFacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.members.resolve.RenderFacet;
import org.apache.isis.core.progmodel.facets.members.resolve.RenderFacetAnnotation;
import org.apache.isis.core.progmodel.facets.members.resolve.RenderFacetProperties;
import org.apache.isis.core.progmodel.facets.members.resolve.RenderFacetViaResolveAnnotation;

public class RenderOrResolveFacetFactory
extends FacetFactoryAbstract
implements ContributeeMemberFacetFactory {
    public RenderOrResolveFacetFactory() {
        super(FeatureType.MEMBERS);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        RenderFacet renderFacet = RenderOrResolveFacetFactory.createFromMetadataPropertiesIfPossible(processMethodContext);
        if (renderFacet == null) {
            renderFacet = RenderOrResolveFacetFactory.createFromRenderAnnotationIfPossible(processMethodContext);
        }
        if (renderFacet == null) {
            renderFacet = RenderOrResolveFacetFactory.createFromResolveAnnotationIfPossible(processMethodContext);
        }
        FacetUtil.addFacet(renderFacet);
    }

    @Override
    public void process(ContributeeMemberFacetFactory.ProcessContributeeMemberContext processMemberContext) {
        RenderFacet renderFacet = RenderOrResolveFacetFactory.createFromMetadataPropertiesIfPossible(processMemberContext);
        FacetUtil.addFacet(renderFacet);
    }

    private static RenderFacet createFromMetadataPropertiesIfPossible(FacetFactory.ProcessContextWithMetadataProperties<? extends FacetHolder> pcwmp) {
        FacetHolder holder = pcwmp.getFacetHolder();
        Properties properties = pcwmp.metadataProperties("render");
        return properties != null ? new RenderFacetProperties(properties, holder) : null;
    }

    private static RenderFacet createFromRenderAnnotationIfPossible(FacetFactory.ProcessMethodContext processMethodContext) {
        Render renderAnnotation = Annotations.getAnnotation(processMethodContext.getMethod(), Render.class);
        return renderAnnotation == null ? null : new RenderFacetAnnotation((FacetHolder)processMethodContext.getFacetHolder(), renderAnnotation.value());
    }

    private static RenderFacet createFromResolveAnnotationIfPossible(FacetFactory.ProcessMethodContext processMethodContext) {
        Resolve resolveAnnotation = Annotations.getAnnotation(processMethodContext.getMethod(), Resolve.class);
        return resolveAnnotation == null ? null : new RenderFacetViaResolveAnnotation((FacetHolder)processMethodContext.getFacetHolder(), resolveAnnotation.value());
    }
}

