/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.object.bookmarkable.annotation;

import java.util.List;
import org.apache.isis.applib.annotation.ActionSemantics;
import org.apache.isis.applib.annotation.BookmarkPolicy;
import org.apache.isis.applib.annotation.Bookmarkable;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MetaModelValidatorRefiner;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.actions.semantics.ActionSemanticsFacet;
import org.apache.isis.core.metamodel.facets.object.bookmarkable.BookmarkPolicyFacet;
import org.apache.isis.core.metamodel.facets.object.bookmarkable.BookmarkPolicyFacetFallback;
import org.apache.isis.core.metamodel.facets.object.bookmarkable.BookmarkPolicyFacetViaBookmarkableAnnotation;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorComposite;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorVisiting;
import org.apache.isis.core.metamodel.specloader.validator.ValidationFailures;

public class BookmarkableAnnotationFacetFactory
extends FacetFactoryAbstract
implements MetaModelValidatorRefiner {
    public BookmarkableAnnotationFacetFactory() {
        super(FeatureType.OBJECTS_AND_ACTIONS);
    }

    @Override
    public void process(FacetFactory.ProcessClassContext processClassContext) {
        Bookmarkable annotation = Annotations.getAnnotation(processClassContext.getCls(), Bookmarkable.class);
        FacetUtil.addFacet(this.create(annotation, (FacetHolder)processClassContext.getFacetHolder()));
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        Bookmarkable annotation = Annotations.getAnnotation(processMethodContext.getMethod(), Bookmarkable.class);
        FacetUtil.addFacet(this.create(annotation, (FacetHolder)processMethodContext.getFacetHolder()));
    }

    private BookmarkPolicyFacet create(Bookmarkable annotation, FacetHolder holder) {
        return annotation == null ? new BookmarkPolicyFacetFallback(holder) : new BookmarkPolicyFacetViaBookmarkableAnnotation(holder, annotation.value());
    }

    @Override
    public void refineMetaModelValidator(MetaModelValidatorComposite metaModelValidator, IsisConfiguration configuration) {
        metaModelValidator.add(new MetaModelValidatorVisiting(new MetaModelValidatorVisiting.Visitor(){

            @Override
            public boolean visit(ObjectSpecification objectSpec, ValidationFailures validationFailures) {
                Class<?> cls = objectSpec.getCorrespondingClass();
                List<ObjectAction> objectActions = objectSpec.getObjectActions(Contributed.EXCLUDED);
                for (ObjectAction objectAction : objectActions) {
                    ActionSemanticsFacet semanticsFacet;
                    BookmarkPolicyFacet bookmarkFacet = objectAction.getFacet(BookmarkPolicyFacet.class);
                    if (bookmarkFacet == null || bookmarkFacet.isNoop() || bookmarkFacet.value() == BookmarkPolicy.NEVER || (semanticsFacet = objectAction.getFacet(ActionSemanticsFacet.class)) != null && !semanticsFacet.isNoop() && semanticsFacet.value() == ActionSemantics.Of.SAFE) continue;
                    validationFailures.add("Action %s is bookmarkable but action semantics are not explicitly indicated as being safe.  Either add @ActionSemantics(Of.Safe), or remove @Bookmarkable.", objectAction.getIdentifier().toClassAndNameIdentityString());
                }
                return true;
            }
        }));
    }
}

