/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.object.defaults;

import com.google.common.base.Strings;
import org.apache.isis.applib.adapters.DefaultsProvider;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.lang.ClassUtil;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;

public final class DefaultsProviderUtil {
    public static final String DEFAULTS_PROVIDER_NAME_KEY_PREFIX = "isis.reflector.java.facets.defaulted.";
    public static final String DEFAULTS_PROVIDER_NAME_KEY_SUFFIX = ".providerName";

    private DefaultsProviderUtil() {
    }

    public static String defaultsProviderNameFromConfiguration(Class<?> type, IsisConfiguration configuration) {
        String key = DEFAULTS_PROVIDER_NAME_KEY_PREFIX + type.getCanonicalName() + DEFAULTS_PROVIDER_NAME_KEY_SUFFIX;
        String defaultsProviderName = configuration.getString(key);
        return !Strings.isNullOrEmpty((String)defaultsProviderName) ? defaultsProviderName : null;
    }

    public static Class<?> defaultsProviderOrNull(Class<?> candidateClass, String classCandidateName) {
        Class<?> type = candidateClass != null ? ClassUtil.implementingClassOrNull(candidateClass.getName(), DefaultsProvider.class, FacetHolder.class) : null;
        return type != null ? type : ClassUtil.implementingClassOrNull(classCandidateName, DefaultsProvider.class, FacetHolder.class);
    }
}

