/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.object.disabled.method;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import org.apache.isis.applib.Identifier;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.util.AdapterInvokeUtils;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facets.ImperativeFacet;
import org.apache.isis.core.progmodel.facets.object.disabled.DisabledObjectFacetAbstract;

public class DisabledObjectFacetViaDisabledMethod
extends DisabledObjectFacetAbstract
implements ImperativeFacet {
    private final Method method;

    public DisabledObjectFacetViaDisabledMethod(Method method, FacetHolder holder) {
        super(holder);
        this.method = method;
    }

    @Override
    public List<Method> getMethods() {
        return Collections.singletonList(this.method);
    }

    @Override
    public ImperativeFacet.Intent getIntent(Method method) {
        return ImperativeFacet.Intent.CHECK_IF_DISABLED;
    }

    @Override
    public boolean impliesResolve() {
        return true;
    }

    @Override
    public boolean impliesObjectChanged() {
        return false;
    }

    @Override
    public String disabledReason(ObjectAdapter owningAdapter, Identifier identifier) {
        Identifier.Type type = identifier.getType();
        return (String)AdapterInvokeUtils.invoke(this.method, owningAdapter, type);
    }

    @Override
    protected String toStringValues() {
        return "method=" + this.method;
    }

    @Override
    public void copyOnto(FacetHolder holder) {
        DisabledObjectFacetViaDisabledMethod clonedFacet = new DisabledObjectFacetViaDisabledMethod(this.method, holder);
        FacetUtil.addFacet(clonedFacet);
    }
}

