/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.object.hidden.method;

import java.lang.reflect.Method;
import org.apache.isis.applib.events.VisibilityEvent;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.util.AdapterInvokeUtils;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.interactions.VisibilityContext;
import org.apache.isis.core.progmodel.facets.object.hidden.HiddenObjectFacetAbstract;

public class HiddenObjectFacetViaHiddenMethod
extends HiddenObjectFacetAbstract {
    private final Method method;

    public HiddenObjectFacetViaHiddenMethod(Method method, FacetHolder holder) {
        super(holder);
        this.method = method;
    }

    @Override
    public String hides(VisibilityContext<? extends VisibilityEvent> ic) {
        ObjectAdapter toValidate = ic.getTarget();
        return toValidate != null ? this.hiddenReason(toValidate) : null;
    }

    @Override
    public String hiddenReason(ObjectAdapter target) {
        if (target == null) {
            return null;
        }
        Boolean isHidden = (Boolean)AdapterInvokeUtils.invoke(this.method, target);
        return isHidden != false ? "Hidden" : null;
    }

    @Override
    public void copyOnto(FacetHolder holder) {
        HiddenObjectFacetViaHiddenMethod clonedFacet = new HiddenObjectFacetViaHiddenMethod(this.method, holder);
        FacetUtil.addFacet(clonedFacet);
    }
}

