/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.object.ignore.javalang;

import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.isis.core.commons.factory.InstanceUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.methodutils.MethodScope;

public abstract class AbstractRemoveMethodsFacetFactory
extends FacetFactoryAbstract {
    private final List<MethodAndParameterTypes> methodsToIgnore = Lists.newArrayList();

    public AbstractRemoveMethodsFacetFactory(Class<?> typeToIgnore) {
        super(FeatureType.OBJECTS_ONLY);
        Method[] methods;
        for (Method method : methods = typeToIgnore.getMethods()) {
            this.methodsToIgnore.add(new MethodAndParameterTypes(method.getName(), method.getParameterTypes()));
        }
    }

    public AbstractRemoveMethodsFacetFactory(String typeToIgnoreIfOnClasspath) {
        super(FeatureType.OBJECTS_ONLY);
        try {
            Class<?> typeToIgnore = InstanceUtil.loadClass(typeToIgnoreIfOnClasspath);
            this.addMethodsToBeIgnored(typeToIgnore);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addMethodsToBeIgnored(Class<?> typeToIgnore) {
        Method[] methods;
        for (Method method : methods = typeToIgnore.getMethods()) {
            this.methodsToIgnore.add(new MethodAndParameterTypes(method.getName(), method.getParameterTypes()));
        }
    }

    @Override
    public void process(FacetFactory.ProcessClassContext processClassContext) {
        for (MethodAndParameterTypes mapt : this.methodsToIgnore) {
            processClassContext.removeMethod(MethodScope.OBJECT, mapt.methodName, null, mapt.methodParameters);
        }
    }

    private static class MethodAndParameterTypes {
        private final String methodName;
        private final Class<?>[] methodParameters;

        public MethodAndParameterTypes(String methodName, Class<?>[] methodParameters) {
            this.methodName = methodName;
            this.methodParameters = methodParameters;
        }
    }
}

