/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.object.membergroups;

import java.util.List;
import java.util.Properties;
import org.apache.isis.applib.annotation.MemberGroupLayout;
import org.apache.isis.applib.annotation.MemberGroups;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.filter.Filter;
import org.apache.isis.applib.filter.Filters;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MetaModelValidatorRefiner;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.object.membergroups.MemberGroupLayoutFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorComposite;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorVisiting;
import org.apache.isis.core.metamodel.specloader.validator.ValidationFailures;
import org.apache.isis.core.progmodel.facets.object.membergroups.MemberGroupLayoutFacetAnnotation;
import org.apache.isis.core.progmodel.facets.object.membergroups.MemberGroupLayoutFacetFallback;
import org.apache.isis.core.progmodel.facets.object.membergroups.MemberGroupLayoutFacetProperties;
import org.apache.isis.core.progmodel.facets.object.membergroups.MemberGroupsFacetAnnotation;

public class MemberGroupLayoutFacetFactory
extends FacetFactoryAbstract
implements MetaModelValidatorRefiner {
    public MemberGroupLayoutFacetFactory() {
        super(FeatureType.OBJECTS_ONLY);
    }

    @Override
    public void process(FacetFactory.ProcessClassContext processClassContext) {
        FacetUtil.addFacet(this.create(processClassContext));
    }

    private MemberGroupLayoutFacet create(FacetFactory.ProcessClassContext processClassContext) {
        Object holder = processClassContext.getFacetHolder();
        Class<?> cls = processClassContext.getCls();
        Properties properties = processClassContext.metadataProperties("memberGroupLayout");
        if (properties != null) {
            return new MemberGroupLayoutFacetProperties(properties, (FacetHolder)holder);
        }
        MemberGroupLayout mglAnnot = Annotations.getAnnotation(cls, MemberGroupLayout.class);
        if (mglAnnot != null) {
            return new MemberGroupLayoutFacetAnnotation(mglAnnot, (FacetHolder)holder);
        }
        MemberGroups mgAnnot = Annotations.getAnnotation(cls, MemberGroups.class);
        if (mgAnnot != null) {
            return new MemberGroupsFacetAnnotation(mgAnnot, (FacetHolder)processClassContext.getFacetHolder());
        }
        return new MemberGroupLayoutFacetFallback((FacetHolder)holder);
    }

    @Override
    public void refineMetaModelValidator(MetaModelValidatorComposite metaModelValidator, IsisConfiguration configuration) {
        metaModelValidator.add(new MetaModelValidatorVisiting(this.newValidatorVisitor()));
    }

    private MetaModelValidatorVisiting.Visitor newValidatorVisitor() {
        return new MetaModelValidatorVisiting.Visitor(){

            @Override
            public boolean visit(ObjectSpecification objectSpec, ValidationFailures validationFailures) {
                MemberGroupLayoutFacet facet = objectSpec.getFacet(MemberGroupLayoutFacet.class);
                MemberGroupLayout.ColumnSpans columnSpans = facet.getColumnSpans();
                List<String> middle = facet.getMiddle();
                List<String> right = facet.getRight();
                int numCollections = this.numCollectionsOf(objectSpec);
                if (columnSpans.getMiddle() == 0 && !middle.isEmpty()) {
                    validationFailures.add("%s MemberGroupLayout: middle (property) column is 0 for ColumnSpans (%s), but groups have been listed (%s).  NB: ColumnSpans may have been defaulted if could not be parsed.", objectSpec.getIdentifier().getClassName(), columnSpans.name(), middle);
                }
                if (columnSpans.getMiddle() <= 0 || middle.isEmpty()) {
                    // empty if block
                }
                if (columnSpans.getRight() == 0 && !right.isEmpty()) {
                    validationFailures.add("%s MemberGroupLayout: right (property) column is 0 for ColumnSpans (%s), but groups have been listed (%s).  NB: ColumnSpans may have been defaulted if could not be parsed.", objectSpec.getIdentifier().getClassName(), columnSpans.name(), right);
                }
                if (columnSpans.getRight() <= 0 || right.isEmpty()) {
                    // empty if block
                }
                if (columnSpans.getCollections() == 0 && numCollections > 0) {
                    validationFailures.add("%s MemberGroupLayout: collections column is 0 for ColumnSpans (%s), but there are (up to) %d visible collections", objectSpec.getIdentifier().getClassName(), columnSpans.name(), numCollections);
                }
                return true;
            }

            private int numCollectionsOf(ObjectSpecification objectSpec) {
                List<ObjectAssociation> objectCollections = objectSpec.getAssociations(Contributed.EXCLUDED, (Filter<ObjectAssociation>)Filters.and((Filter[])new Filter[]{ObjectAssociation.Filters.staticallyVisible(Where.OBJECT_FORMS), ObjectAssociation.Filters.COLLECTIONS}));
                return objectCollections.size();
            }
        };
    }
}

