/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.object.parseable;

import com.google.common.base.Strings;
import org.apache.isis.applib.annotation.Parseable;
import org.apache.isis.core.commons.authentication.AuthenticationSessionProvider;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.deployment.DeploymentCategory;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjector;
import org.apache.isis.core.progmodel.facets.object.parseable.ParseableFacetAbstract;
import org.apache.isis.core.progmodel.facets.object.parseable.ParserUtil;

public class ParseableFacetAnnotation
extends ParseableFacetAbstract {
    private static String parserName(Class<?> annotatedClass, IsisConfiguration configuration) {
        Parseable annotation = annotatedClass.getAnnotation(Parseable.class);
        String parserName = annotation.parserName();
        if (!Strings.isNullOrEmpty((String)parserName)) {
            return parserName;
        }
        return ParserUtil.parserNameFromConfiguration(annotatedClass, configuration);
    }

    private static Class<?> parserClass(Class<?> annotatedClass) {
        Parseable annotation = annotatedClass.getAnnotation(Parseable.class);
        return annotation.parserClass();
    }

    public ParseableFacetAnnotation(Class<?> annotatedClass, IsisConfiguration configuration, FacetHolder holder, DeploymentCategory deploymentCategory, AuthenticationSessionProvider authenticationSessionProvider, AdapterManager adapterManager, ServicesInjector dependencyInjector) {
        this(ParseableFacetAnnotation.parserName(annotatedClass, configuration), ParseableFacetAnnotation.parserClass(annotatedClass), holder, deploymentCategory, authenticationSessionProvider, adapterManager, dependencyInjector);
    }

    private ParseableFacetAnnotation(String candidateParserName, Class<?> candidateParserClass, FacetHolder holder, DeploymentCategory deploymentCategory, AuthenticationSessionProvider authenticationSessionProvider, AdapterManager adapterManager, ServicesInjector dependencyInjector) {
        super(candidateParserName, candidateParserClass, holder, deploymentCategory, authenticationSessionProvider, dependencyInjector, adapterManager);
    }
}

