/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.object.parseable;

import com.google.common.base.Strings;
import org.apache.isis.applib.adapters.Parser;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.lang.ClassUtil;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;

public final class ParserUtil {
    public static final String PARSER_NAME_KEY_PREFIX = "isis.reflector.java.facets.parser.";
    public static final String PARSER_NAME_KEY_SUFFIX = ".parserName";

    private ParserUtil() {
    }

    static String parserNameFromConfiguration(Class<?> type, IsisConfiguration configuration) {
        String key = PARSER_NAME_KEY_PREFIX + type.getCanonicalName() + PARSER_NAME_KEY_SUFFIX;
        String parserName = configuration.getString(key);
        return !Strings.isNullOrEmpty((String)parserName) ? parserName : null;
    }

    public static Class<? extends Parser<?>> parserOrNull(Class<?> candidateClass, String classCandidateName) {
        Class<?> type = candidateClass != null ? ClassUtil.implementingClassOrNull(candidateClass.getName(), Parser.class, FacetHolder.class) : null;
        return type != null ? type : ClassUtil.implementingClassOrNull(classCandidateName, Parser.class, FacetHolder.class);
    }
}

