/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.object.plural.staticmethod;

import java.lang.reflect.Method;
import org.apache.isis.core.commons.lang.MethodExtensions;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.methodutils.MethodScope;
import org.apache.isis.core.progmodel.facets.MethodFinderUtils;
import org.apache.isis.core.progmodel.facets.MethodPrefixBasedFacetFactoryAbstract;
import org.apache.isis.core.progmodel.facets.object.plural.staticmethod.PluralFacetViaMethod;

public class PluralMethodFacetFactory
extends MethodPrefixBasedFacetFactoryAbstract {
    private static final String PLURAL_NAME = "pluralName";
    private static final String[] PREFIXES = new String[]{"pluralName"};

    public PluralMethodFacetFactory() {
        super(FeatureType.OBJECTS_ONLY, MethodPrefixBasedFacetFactoryAbstract.OrphanValidation.VALIDATE, PREFIXES);
    }

    @Override
    public void process(FacetFactory.ProcessClassContext processClassContext) {
        Class<?> type = processClassContext.getCls();
        Object facetHolder = processClassContext.getFacetHolder();
        Method method = MethodFinderUtils.findMethod(type, MethodScope.CLASS, PLURAL_NAME, String.class, NO_PARAMETERS_TYPES);
        if (method != null) {
            String name = (String)MethodExtensions.invokeStatic(method);
            processClassContext.removeMethod(method);
            FacetUtil.addFacet(new PluralFacetViaMethod(name, (FacetHolder)facetHolder));
        }
    }
}

