/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.object.title;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import org.apache.isis.applib.profiles.Localization;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.util.AdapterInvokeUtils;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.ImperativeFacet;
import org.apache.isis.core.metamodel.facets.object.title.TitleFacetAbstract;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TitleFacetViaTitleMethod
extends TitleFacetAbstract
implements ImperativeFacet {
    private static final Logger LOG = LoggerFactory.getLogger(TitleFacetViaTitleMethod.class);
    private final Method method;

    public TitleFacetViaTitleMethod(Method method, FacetHolder holder) {
        super(holder);
        this.method = method;
    }

    @Override
    public List<Method> getMethods() {
        return Collections.singletonList(this.method);
    }

    @Override
    public ImperativeFacet.Intent getIntent(Method method) {
        return ImperativeFacet.Intent.UI_HINT;
    }

    @Override
    public boolean impliesResolve() {
        return true;
    }

    @Override
    public boolean impliesObjectChanged() {
        return false;
    }

    @Override
    public String title(ObjectAdapter owningAdapter, Localization localization) {
        try {
            return (String)AdapterInvokeUtils.invoke(this.method, owningAdapter);
        }
        catch (RuntimeException ex) {
            LOG.warn("title failure", (Throwable)ex);
            return "Failed Title";
        }
    }
}

