/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.object.title;

import java.lang.reflect.Method;
import org.apache.isis.core.commons.lang.ClassExtensions;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.object.title.TitleFacet;
import org.apache.isis.core.metamodel.methodutils.MethodScope;
import org.apache.isis.core.progmodel.facets.MethodFinderUtils;
import org.apache.isis.core.progmodel.facets.MethodPrefixBasedFacetFactoryAbstract;
import org.apache.isis.core.progmodel.facets.object.title.TitleFacetViaTitleMethod;
import org.apache.isis.core.progmodel.facets.object.title.TitleFacetViaToStringMethod;

public class TitleMethodFacetFactory
extends MethodPrefixBasedFacetFactoryAbstract {
    private static final String TO_STRING = "toString";
    private static final String TITLE = "title";
    private static final String[] PREFIXES = new String[]{"toString", "title"};

    public TitleMethodFacetFactory() {
        super(FeatureType.OBJECTS_ONLY, MethodPrefixBasedFacetFactoryAbstract.OrphanValidation.VALIDATE, PREFIXES);
    }

    @Override
    public void process(FacetFactory.ProcessClassContext processClassContext) {
        Class<?> cls = processClassContext.getCls();
        TitleFacet facetHolder = processClassContext.getFacetHolder();
        Method method = MethodFinderUtils.findMethod(cls, MethodScope.OBJECT, TITLE, String.class, null);
        if (method != null) {
            processClassContext.removeMethod(method);
            FacetUtil.addFacet(new TitleFacetViaTitleMethod(method, (FacetHolder)((Object)facetHolder)));
            return;
        }
        TitleFacet existingTitleFacet = facetHolder.getFacet(TitleFacet.class);
        if (existingTitleFacet != null && !existingTitleFacet.isNoop()) {
            return;
        }
        try {
            method = MethodFinderUtils.findMethod(cls, MethodScope.OBJECT, TO_STRING, String.class, null);
            if (method == null) {
                return;
            }
            if (ClassExtensions.isJavaClass(method.getDeclaringClass())) {
                return;
            }
            processClassContext.removeMethod(method);
            FacetUtil.addFacet(new TitleFacetViaToStringMethod(method, (FacetHolder)((Object)facetHolder)));
        }
        catch (Exception e) {
            return;
        }
    }
}

