/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.object.value;

import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.util.Locale;
import org.apache.isis.applib.adapters.DefaultsProvider;
import org.apache.isis.applib.adapters.EncoderDecoder;
import org.apache.isis.applib.adapters.Parser;
import org.apache.isis.applib.adapters.ValueSemanticsProvider;
import org.apache.isis.applib.clock.Clock;
import org.apache.isis.applib.profiles.Localization;
import org.apache.isis.core.commons.authentication.AuthenticationSessionProvider;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.exceptions.UnexpectedCallException;
import org.apache.isis.core.commons.exceptions.UnknownTypeException;
import org.apache.isis.core.commons.lang.LocaleUtil;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetAbstract;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.parseable.InvalidEntryException;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjector;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.SpecificationLoader;
import org.apache.isis.core.progmodel.facets.object.value.ValueSemanticsProviderContext;

public abstract class ValueSemanticsProviderAndFacetAbstract<T>
extends FacetAbstract
implements ValueSemanticsProvider<T>,
EncoderDecoder<T>,
Parser<T>,
DefaultsProvider<T> {
    private final Class<T> adaptedClass;
    private final int typicalLength;
    private final boolean immutable;
    private final boolean equalByContent;
    private final T defaultValue;
    private ObjectSpecification specification;
    private final IsisConfiguration configuration;
    private final ValueSemanticsProviderContext context;

    public ValueSemanticsProviderAndFacetAbstract(Class<? extends Facet> adapterFacetType, FacetHolder holder, Class<T> adaptedClass, int typicalLength, Immutability immutability, EqualByContent equalByContent, T defaultValue, IsisConfiguration configuration, ValueSemanticsProviderContext context) {
        super(adapterFacetType, holder, FacetAbstract.Derivation.NOT_DERIVED);
        this.adaptedClass = adaptedClass;
        this.typicalLength = typicalLength;
        this.immutable = immutability == Immutability.IMMUTABLE;
        this.equalByContent = equalByContent == EqualByContent.HONOURED;
        this.defaultValue = defaultValue;
        this.configuration = configuration;
        this.context = context;
    }

    public ObjectSpecification getSpecification() {
        if (this.specification == null) {
            this.specification = this.getSpecificationLookup().loadSpecification(this.getAdaptedClass());
        }
        return this.specification;
    }

    public final Class<T> getAdaptedClass() {
        return this.adaptedClass;
    }

    @Override
    public boolean alwaysReplace() {
        return false;
    }

    public EncoderDecoder<T> getEncoderDecoder() {
        return this;
    }

    public Parser<T> getParser() {
        return this;
    }

    public DefaultsProvider<T> getDefaultsProvider() {
        return this;
    }

    public boolean isEqualByContent() {
        return this.equalByContent;
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    public T parseTextEntry(Object context, String entry, Localization localization) {
        if (entry == null) {
            throw new IllegalArgumentException();
        }
        if (entry.trim().equals("")) {
            if (this.mustHaveEntry()) {
                throw new InvalidEntryException("An entry is required");
            }
            return null;
        }
        return this.doParse(context, entry, localization);
    }

    protected T doParse(Object context, String entry) {
        throw new UnexpectedCallException();
    }

    protected T doParse(Object context, String entry, Localization localization) {
        return this.doParse(context, entry);
    }

    private final boolean mustHaveEntry() {
        return this.adaptedClass.isPrimitive();
    }

    public String displayTitleOf(Object object, Localization localization) {
        if (object == null) {
            return "";
        }
        return this.titleString(object, localization);
    }

    public String displayTitleOf(Object object, String usingMask) {
        if (object == null) {
            return "";
        }
        return this.titleStringWithMask(object, usingMask);
    }

    public String parseableTitleOf(Object existing) {
        return this.displayTitleOf(existing, (Localization)null);
    }

    protected String titleString(Format formatter, Object object) {
        return object == null ? "" : formatter.format(object);
    }

    protected abstract String titleString(Object var1, Localization var2);

    public abstract String titleStringWithMask(Object var1, String var2);

    public final int typicalLength() {
        return this.typicalLength;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public String toEncodedString(Object object) {
        return this.doEncode(object);
    }

    public T fromEncodedString(String data) {
        return this.doRestore(data);
    }

    protected abstract String doEncode(Object var1);

    protected abstract T doRestore(String var1);

    protected NumberFormat determineNumberFormat(String suffix) {
        String formatRequired = this.getConfiguration().getString("isis." + suffix);
        if (formatRequired != null) {
            return new DecimalFormat(formatRequired);
        }
        return NumberFormat.getNumberInstance(this.findLocale());
    }

    private Locale findLocale() {
        String localeStr = this.getConfiguration().getString("isis.locale");
        Locale findLocale = LocaleUtil.findLocale(localeStr);
        return findLocale != null ? findLocale : Locale.getDefault();
    }

    protected ObjectAdapter createAdapter(Class<?> type, Object object) {
        ObjectSpecification specification = this.getSpecificationLookup().loadSpecification(type);
        if (specification.isNotCollection()) {
            return this.getAdapterManager().adapterFor(object);
        }
        throw new UnknownTypeException("not an object, is this a collection?");
    }

    protected IsisConfiguration getConfiguration() {
        return this.configuration;
    }

    protected ValueSemanticsProviderContext getContext() {
        return this.context;
    }

    protected AdapterManager getAdapterManager() {
        return this.context.getAdapterManager();
    }

    protected SpecificationLoader getSpecificationLookup() {
        return this.context.getSpecificationLookup();
    }

    protected ServicesInjector getDependencyInjector() {
        return this.context.getDependencyInjector();
    }

    protected AuthenticationSessionProvider getAuthenticationSessionProvider() {
        return this.context.getAuthenticationSessionProvider();
    }

    protected static Clock getClock() {
        return Clock.getInstance();
    }

    public static enum EqualByContent {
        HONOURED,
        NOT_HONOURED;


        public static EqualByContent of(boolean equalByContent) {
            return equalByContent ? HONOURED : NOT_HONOURED;
        }
    }

    public static enum Immutability {
        IMMUTABLE,
        NOT_IMMUTABLE;


        public static Immutability of(boolean immutable) {
            return immutable ? IMMUTABLE : NOT_IMMUTABLE;
        }
    }
}

