/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.paged;

import java.util.Properties;
import org.apache.isis.applib.annotation.Paged;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.config.IsisConfigurationAware;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.ContributeeMemberFacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.object.paged.PagedFacet;
import org.apache.isis.core.progmodel.facets.paged.PagedFacetAnnotation;
import org.apache.isis.core.progmodel.facets.paged.PagedFacetProperties;

public class PagedOnParentedCollectionFacetFactory
extends FacetFactoryAbstract
implements ContributeeMemberFacetFactory,
IsisConfigurationAware {
    private IsisConfiguration configuration;

    public PagedOnParentedCollectionFacetFactory() {
        super(FeatureType.COLLECTIONS_ONLY);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        PagedFacet pagedFacet = this.createFromMetadataPropertiesIfPossible(processMethodContext);
        if (pagedFacet == null) {
            pagedFacet = this.createFromPagedAnnotationIfPossible(processMethodContext);
        }
        FacetUtil.addFacet(pagedFacet);
    }

    @Override
    public void process(ContributeeMemberFacetFactory.ProcessContributeeMemberContext processMemberContext) {
        PagedFacet pagedFacet = this.createFromMetadataPropertiesIfPossible(processMemberContext);
        FacetUtil.addFacet(pagedFacet);
    }

    private PagedFacet createFromMetadataPropertiesIfPossible(FacetFactory.ProcessContextWithMetadataProperties<?> processMethodContext) {
        Properties properties = processMethodContext.metadataProperties("paged");
        return properties != null ? new PagedFacetProperties(properties, (FacetHolder)processMethodContext.getFacetHolder()) : null;
    }

    private PagedFacet createFromPagedAnnotationIfPossible(FacetFactory.ProcessMethodContext processMethodContext) {
        Paged annotation = Annotations.getAnnotation(processMethodContext.getMethod(), Paged.class);
        return annotation != null ? new PagedFacetAnnotation((FacetHolder)processMethodContext.getFacetHolder(), annotation.value()) : null;
    }

    public IsisConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void setConfiguration(IsisConfiguration configuration) {
        this.configuration = configuration;
    }
}

