/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.param.choices.methodnum;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import org.apache.isis.core.commons.lang.ListExtensions;
import org.apache.isis.core.commons.lang.StringExtensions;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManagerAware;
import org.apache.isis.core.metamodel.exceptions.MetaModelException;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetedMethod;
import org.apache.isis.core.metamodel.facets.FacetedMethodParameter;
import org.apache.isis.core.metamodel.facets.actions.choices.ActionChoicesFacet;
import org.apache.isis.core.metamodel.methodutils.MethodScope;
import org.apache.isis.core.progmodel.facets.MethodFinderUtils;
import org.apache.isis.core.progmodel.facets.MethodPrefixBasedFacetFactoryAbstract;
import org.apache.isis.core.progmodel.facets.param.choices.methodnum.ActionParameterChoicesFacetViaMethod;

public class ActionParameterChoicesFacetFactory
extends MethodPrefixBasedFacetFactoryAbstract
implements AdapterManagerAware {
    private static final String[] PREFIXES = new String[0];
    private AdapterManager adapterManager;

    public ActionParameterChoicesFacetFactory() {
        super(FeatureType.ACTIONS_ONLY, MethodPrefixBasedFacetFactoryAbstract.OrphanValidation.VALIDATE, PREFIXES);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        FacetedMethod facetedMethod = (FacetedMethod)processMethodContext.getFacetHolder();
        List<FacetedMethodParameter> holderList = facetedMethod.getParameters();
        this.attachChoicesFacetForParametersIfChoicesNumMethodIsFound(processMethodContext, holderList);
    }

    private void attachChoicesFacetForParametersIfChoicesNumMethodIsFound(FacetFactory.ProcessMethodContext processMethodContext, List<FacetedMethodParameter> parameters) {
        if (parameters.isEmpty()) {
            return;
        }
        Method actionMethod = processMethodContext.getMethod();
        Class<?>[] paramTypes = actionMethod.getParameterTypes();
        for (int i = 0; i < paramTypes.length; ++i) {
            Class<?> arrayOfParamType = Array.newInstance(paramTypes[i], 0).getClass();
            Method choicesMethod = ActionParameterChoicesFacetFactory.findChoicesNumMethodReturning(processMethodContext, i);
            if (choicesMethod == null) continue;
            processMethodContext.removeMethod(choicesMethod);
            FacetedMethod facetedMethod = (FacetedMethod)processMethodContext.getFacetHolder();
            if (facetedMethod.containsDoOpFacet(ActionChoicesFacet.class)) {
                Class<?> cls = processMethodContext.getCls();
                throw new MetaModelException(cls + " uses both old and new choices syntax - must use one or other");
            }
            FacetedMethodParameter paramAsHolder = parameters.get(i);
            FacetUtil.addFacet(new ActionParameterChoicesFacetViaMethod(choicesMethod, arrayOfParamType, paramAsHolder, this.getSpecificationLoader(), this.getAdapterManager()));
        }
    }

    private static Method findChoicesNumMethodReturning(FacetFactory.ProcessMethodContext processMethodContext, int n) {
        Method actionMethod = processMethodContext.getMethod();
        List<Class<?>> paramTypes = ListExtensions.mutableCopy(actionMethod.getParameterTypes());
        Class<?> arrayOfParamType = Array.newInstance(paramTypes.get(n), 0).getClass();
        int numParamTypes = paramTypes.size();
        for (int i = 0; i < numParamTypes + 1; ++i) {
            Method method = ActionParameterChoicesFacetFactory.findChoicesNumMethodReturning(processMethodContext, n, paramTypes.toArray(new Class[0]), arrayOfParamType);
            if (method != null) {
                return method;
            }
            method = ActionParameterChoicesFacetFactory.findChoicesNumMethodReturning(processMethodContext, n, paramTypes.toArray(new Class[0]), Collection.class);
            if (method != null) {
                return method;
            }
            if (paramTypes.isEmpty()) continue;
            paramTypes.remove(paramTypes.size() - 1);
        }
        return null;
    }

    private static Method findChoicesNumMethodReturning(FacetFactory.ProcessMethodContext processMethodContext, int n, Class<?>[] paramTypes, Class<?> returnType) {
        Class<?> cls = processMethodContext.getCls();
        Method actionMethod = processMethodContext.getMethod();
        String capitalizedName = StringExtensions.asCapitalizedName(actionMethod.getName());
        String name = "choices" + n + capitalizedName;
        return MethodFinderUtils.findMethod(cls, MethodScope.OBJECT, name, returnType, paramTypes);
    }

    @Override
    public void setAdapterManager(AdapterManager adapterManager) {
        this.adapterManager = adapterManager;
    }

    private AdapterManager getAdapterManager() {
        return this.adapterManager;
    }
}

