/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.param.choices.methodnum;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import org.apache.isis.core.commons.lang.ObjectExtensions;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.adapter.util.AdapterInvokeUtils;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.ImperativeFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.SpecificationLoader;
import org.apache.isis.core.progmodel.facets.CollectionUtils;
import org.apache.isis.core.progmodel.facets.param.choices.ActionParameterChoicesFacetAbstract;

public class ActionParameterChoicesFacetViaMethod
extends ActionParameterChoicesFacetAbstract
implements ImperativeFacet {
    private final Method method;
    private final Class<?> choicesType;

    public ActionParameterChoicesFacetViaMethod(Method method, Class<?> choicesType, FacetHolder holder, SpecificationLoader specificationLookup, AdapterManager adapterManager) {
        super(holder, specificationLookup, adapterManager);
        this.method = method;
        this.choicesType = choicesType;
    }

    @Override
    public List<Method> getMethods() {
        return Collections.singletonList(this.method);
    }

    @Override
    public ImperativeFacet.Intent getIntent(Method method) {
        return ImperativeFacet.Intent.CHOICES_OR_AUTOCOMPLETE;
    }

    @Override
    public boolean impliesResolve() {
        return true;
    }

    @Override
    public boolean impliesObjectChanged() {
        return false;
    }

    @Override
    public Object[] getChoices(ObjectAdapter adapter, List<ObjectAdapter> argumentsIfAvailable) {
        Object choices = AdapterInvokeUtils.invokeAutofit(this.method, adapter, argumentsIfAvailable, this.getAdapterManager());
        if (choices == null) {
            return new Object[0];
        }
        if (choices.getClass().isArray()) {
            return ObjectExtensions.asArray(choices);
        }
        ObjectSpecification specification = this.getSpecification(this.choicesType);
        return CollectionUtils.getCollectionAsObjectArray(choices, specification, this.getAdapterManager());
    }

    @Override
    protected String toStringValues() {
        return "method=" + this.method + ",type=" + this.choicesType;
    }
}

