/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.param.defaults.methodnum;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.adapter.util.AdapterInvokeUtils;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.ImperativeFacet;
import org.apache.isis.core.progmodel.facets.param.defaults.ActionParameterDefaultsFacetAbstract;

public class ActionParameterDefaultsFacetViaMethod
extends ActionParameterDefaultsFacetAbstract
implements ImperativeFacet {
    private final Method method;
    private final AdapterManager adapterManager;

    public ActionParameterDefaultsFacetViaMethod(Method method, FacetHolder holder, AdapterManager adapterManager) {
        super(holder);
        this.method = method;
        this.adapterManager = adapterManager;
    }

    @Override
    public List<Method> getMethods() {
        return Collections.singletonList(this.method);
    }

    @Override
    public ImperativeFacet.Intent getIntent(Method method) {
        return ImperativeFacet.Intent.DEFAULTS;
    }

    @Override
    public boolean impliesResolve() {
        return true;
    }

    @Override
    public boolean impliesObjectChanged() {
        return false;
    }

    @Override
    public Object getDefault(ObjectAdapter target, List<ObjectAdapter> argumentsIfAvailable) {
        return AdapterInvokeUtils.invokeAutofit(this.method, target, argumentsIfAvailable, this.getAdapterManager());
    }

    @Override
    protected String toStringValues() {
        return "method=" + this.method;
    }

    protected AdapterManager getAdapterManager() {
        return this.adapterManager;
    }
}

