/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.param.mandatory.staticmethod;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.isis.core.commons.lang.MethodExtensions;
import org.apache.isis.core.commons.lang.StringExtensions;
import org.apache.isis.core.metamodel.exceptions.MetaModelException;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetedMethod;
import org.apache.isis.core.metamodel.facets.FacetedMethodParameter;
import org.apache.isis.core.metamodel.methodutils.MethodScope;
import org.apache.isis.core.progmodel.facets.MethodFinderUtils;
import org.apache.isis.core.progmodel.facets.MethodPrefixBasedFacetFactoryAbstract;
import org.apache.isis.core.progmodel.facets.param.mandatory.staticmethod.MandatoryFacetOptionalViaMethodForParameter;

public class ActionParameterOptionalViaMethodFacetFactory
extends MethodPrefixBasedFacetFactoryAbstract {
    private static final String[] PREFIXES = new String[]{"optional"};

    public ActionParameterOptionalViaMethodFacetFactory() {
        super(FeatureType.ACTIONS_ONLY, MethodPrefixBasedFacetFactoryAbstract.OrphanValidation.VALIDATE, PREFIXES);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        FacetedMethod facetedMethod = (FacetedMethod)processMethodContext.getFacetHolder();
        List<FacetedMethodParameter> holderList = facetedMethod.getParameters();
        ActionParameterOptionalViaMethodFacetFactory.attachMandatoryFacetForParametersIfOptionalMethodIsFound(processMethodContext, holderList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void attachMandatoryFacetForParametersIfOptionalMethodIsFound(FacetFactory.ProcessMethodContext processMethodContext, List<FacetedMethodParameter> parameters) {
        if (parameters.isEmpty()) {
            return;
        }
        Method actionMethod = processMethodContext.getMethod();
        String capitalizedName = StringExtensions.asCapitalizedName(actionMethod.getName());
        Class<?> cls = processMethodContext.getCls();
        Method optionalMethod = MethodFinderUtils.findMethod(cls, MethodScope.CLASS, "optional" + capitalizedName, boolean[].class, new Class[0]);
        if (optionalMethod == null) {
            return;
        }
        try {
            boolean[] optionals = ActionParameterOptionalViaMethodFacetFactory.invokeOptionalsMethod(optionalMethod, parameters.size());
            for (int i = 0; i < optionals.length; ++i) {
                if (!optionals[i]) continue;
                FacetUtil.addFacet(new MandatoryFacetOptionalViaMethodForParameter(parameters.get(i)));
            }
        }
        finally {
            processMethodContext.removeMethod(optionalMethod);
        }
    }

    private static boolean[] invokeOptionalsMethod(Method optionalMethod, int numElementsRequired) {
        boolean[] optionals = null;
        try {
            optionals = (boolean[])MethodExtensions.invokeStatic(optionalMethod, new Object[0]);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (optionals == null || optionals.length != numElementsRequired) {
            throw new MetaModelException(optionalMethod + " must return an boolean[] array of same size as number of parameters of action");
        }
        return optionals;
    }
}

