/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.param.named.staticmethod;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.isis.core.commons.lang.MethodExtensions;
import org.apache.isis.core.commons.lang.StringExtensions;
import org.apache.isis.core.metamodel.exceptions.MetaModelException;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetedMethod;
import org.apache.isis.core.metamodel.facets.FacetedMethodParameter;
import org.apache.isis.core.metamodel.methodutils.MethodScope;
import org.apache.isis.core.progmodel.facets.MethodFinderUtils;
import org.apache.isis.core.progmodel.facets.MethodPrefixBasedFacetFactoryAbstract;
import org.apache.isis.core.progmodel.facets.members.named.staticmethod.NamedFacetViaMethod;

public class ActionParameterNamesMethodFacetFactory
extends MethodPrefixBasedFacetFactoryAbstract {
    private static final String[] PREFIXES = new String[]{"name"};

    public ActionParameterNamesMethodFacetFactory() {
        super(FeatureType.ACTIONS_ONLY, MethodPrefixBasedFacetFactoryAbstract.OrphanValidation.VALIDATE, PREFIXES);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        FacetedMethod facetedMethod = (FacetedMethod)processMethodContext.getFacetHolder();
        List<FacetedMethodParameter> holderList = facetedMethod.getParameters();
        ActionParameterNamesMethodFacetFactory.attachNamedFacetForParametersIfParameterNamesMethodIsFound(processMethodContext, holderList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void attachNamedFacetForParametersIfParameterNamesMethodIsFound(FacetFactory.ProcessMethodContext processMethodContext, List<FacetedMethodParameter> parameters) {
        if (parameters.isEmpty()) {
            return;
        }
        Method actionMethod = processMethodContext.getMethod();
        String capitalizedName = StringExtensions.asCapitalizedName(actionMethod.getName());
        Class<?> cls = processMethodContext.getCls();
        Method namesMethod = MethodFinderUtils.findMethod(cls, MethodScope.CLASS, "name" + capitalizedName, String[].class, new Class[0]);
        if (namesMethod == null) {
            return;
        }
        try {
            String[] names = ActionParameterNamesMethodFacetFactory.invokeNamesMethod(namesMethod, parameters.size());
            for (int i = 0; i < names.length; ++i) {
                FacetUtil.addFacet(new NamedFacetViaMethod(names[i], namesMethod, parameters.get(i)));
            }
        }
        finally {
            processMethodContext.removeMethod(namesMethod);
        }
    }

    private static String[] invokeNamesMethod(Method namesMethod, int numElementsRequired) {
        String[] names = null;
        try {
            names = (String[])MethodExtensions.invokeStatic(namesMethod, new Object[0]);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (names == null || names.length != numElementsRequired) {
            throw new MetaModelException(namesMethod + " must return an String[] array of same size as number of parameters of action");
        }
        return names;
    }
}

