/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.properties.autocomplete;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import org.apache.isis.core.commons.lang.ObjectExtensions;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.adapter.util.AdapterInvokeUtils;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.ImperativeFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.SpecificationLoader;
import org.apache.isis.core.progmodel.facets.CollectionUtils;
import org.apache.isis.core.progmodel.facets.param.autocomplete.MinLengthUtil;
import org.apache.isis.core.progmodel.facets.properties.autocomplete.PropertyAutoCompleteFacetAbstract;

public class PropertyAutoCompleteFacetViaMethod
extends PropertyAutoCompleteFacetAbstract
implements ImperativeFacet {
    private final Method method;
    private final Class<?> choicesClass;
    private final int minLength;
    private final AdapterManager adapterManager;
    private SpecificationLoader specificationLookup;

    public PropertyAutoCompleteFacetViaMethod(Method method, Class<?> choicesClass, FacetHolder holder, SpecificationLoader specificationLookup, AdapterManager adapterManager) {
        super(holder);
        this.method = method;
        this.choicesClass = choicesClass;
        this.specificationLookup = specificationLookup;
        this.adapterManager = adapterManager;
        this.minLength = MinLengthUtil.determineMinLength(method);
    }

    @Override
    public List<Method> getMethods() {
        return Collections.singletonList(this.method);
    }

    @Override
    public ImperativeFacet.Intent getIntent(Method method) {
        return ImperativeFacet.Intent.CHOICES_OR_AUTOCOMPLETE;
    }

    @Override
    public int getMinLength() {
        return this.minLength;
    }

    @Override
    public boolean impliesResolve() {
        return true;
    }

    @Override
    public boolean impliesObjectChanged() {
        return false;
    }

    @Override
    public Object[] autoComplete(ObjectAdapter owningAdapter, String searchArg) {
        Object options = AdapterInvokeUtils.invoke(this.method, owningAdapter, searchArg);
        if (options == null) {
            return null;
        }
        if (options.getClass().isArray()) {
            return ObjectExtensions.asArray(options);
        }
        ObjectSpecification specification = this.specificationLookup.loadSpecification(this.choicesClass);
        return CollectionUtils.getCollectionAsObjectArray(options, specification, this.getAdapterManager());
    }

    @Override
    protected String toStringValues() {
        return "method=" + this.method + ",class=" + this.choicesClass;
    }

    protected AdapterManager getAdapterManager() {
        return this.adapterManager;
    }
}

