/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.properties.choices.method;

import java.lang.reflect.Method;
import org.apache.isis.core.commons.lang.StringExtensions;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManagerAware;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.methodutils.MethodScope;
import org.apache.isis.core.progmodel.facets.MethodFinderUtils;
import org.apache.isis.core.progmodel.facets.MethodPrefixBasedFacetFactoryAbstract;
import org.apache.isis.core.progmodel.facets.properties.choices.method.PropertyChoicesFacetViaMethod;

public class PropertyChoicesFacetFactory
extends MethodPrefixBasedFacetFactoryAbstract
implements AdapterManagerAware {
    private static final String[] PREFIXES = new String[]{"choices"};
    private AdapterManager adapterManager;

    public PropertyChoicesFacetFactory() {
        super(FeatureType.PROPERTIES_ONLY, MethodPrefixBasedFacetFactoryAbstract.OrphanValidation.VALIDATE, PREFIXES);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        this.attachPropertyChoicesFacetIfChoicesMethodIsFound(processMethodContext);
    }

    private void attachPropertyChoicesFacetIfChoicesMethodIsFound(FacetFactory.ProcessMethodContext processMethodContext) {
        Method getMethod = processMethodContext.getMethod();
        String capitalizedName = StringExtensions.asJavaBaseName(getMethod.getName());
        Class<?> cls = processMethodContext.getCls();
        Class<?> returnType = getMethod.getReturnType();
        Method choicesMethod = MethodFinderUtils.findMethod(cls, MethodScope.OBJECT, "choices" + capitalizedName, null, NO_PARAMETERS_TYPES);
        if (choicesMethod == null) {
            return;
        }
        processMethodContext.removeMethod(choicesMethod);
        Object property = processMethodContext.getFacetHolder();
        FacetUtil.addFacet(new PropertyChoicesFacetViaMethod(choicesMethod, returnType, (FacetHolder)property, this.getSpecificationLoader(), this.getAdapterManager()));
    }

    @Override
    public void setAdapterManager(AdapterManager adapterManager) {
        this.adapterManager = adapterManager;
    }

    protected AdapterManager getAdapterManager() {
        return this.adapterManager;
    }
}

