/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.properties.event;

import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.List;
import org.apache.isis.applib.annotation.PostsPropertyChangedEvent;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MetaModelValidatorRefiner;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.FacetedMethod;
import org.apache.isis.core.metamodel.facets.accessor.PropertyOrCollectionAccessorFacet;
import org.apache.isis.core.metamodel.facets.collections.sortedby.SortedByFacet;
import org.apache.isis.core.metamodel.facets.properties.modify.PropertyClearFacet;
import org.apache.isis.core.metamodel.facets.properties.modify.PropertySetterFacet;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjector;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjectorAware;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorComposite;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorVisiting;
import org.apache.isis.core.metamodel.specloader.validator.ValidationFailures;
import org.apache.isis.core.progmodel.facets.properties.event.PostsPropertyChangedEventClearFacetAnnotation;
import org.apache.isis.core.progmodel.facets.properties.event.PostsPropertyChangedEventSetterFacetAnnotation;

public class PostsPropertyChangedEventAnnotationFacetFactory
extends FacetFactoryAbstract
implements ServicesInjectorAware,
MetaModelValidatorRefiner {
    private ServicesInjector servicesInjector;

    public PostsPropertyChangedEventAnnotationFacetFactory() {
        super(FeatureType.PROPERTIES_ONLY);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        PropertyClearFacet clearFacet;
        Method method = processMethodContext.getMethod();
        FacetedMethod holder = (FacetedMethod)processMethodContext.getFacetHolder();
        PostsPropertyChangedEvent annotation = Annotations.getAnnotation(method, PostsPropertyChangedEvent.class);
        if (annotation == null) {
            return;
        }
        PropertyOrCollectionAccessorFacet getterFacet = holder.getFacet(PropertyOrCollectionAccessorFacet.class);
        if (getterFacet == null) {
            return;
        }
        PropertySetterFacet setterFacet = holder.getFacet(PropertySetterFacet.class);
        if (setterFacet != null) {
            Class changedEventType = annotation.value();
            FacetUtil.addFacet(new PostsPropertyChangedEventSetterFacetAnnotation(changedEventType, getterFacet, setterFacet, this.servicesInjector, holder));
        }
        if ((clearFacet = holder.getFacet(PropertyClearFacet.class)) != null) {
            Class changedEventType = annotation.value();
            FacetUtil.addFacet(new PostsPropertyChangedEventClearFacetAnnotation(changedEventType, getterFacet, clearFacet, this.servicesInjector, holder));
        }
    }

    @Override
    public void refineMetaModelValidator(MetaModelValidatorComposite metaModelValidator, IsisConfiguration configuration) {
        metaModelValidator.add(new MetaModelValidatorVisiting(this.newValidatorVisitor()));
    }

    protected MetaModelValidatorVisiting.Visitor newValidatorVisitor() {
        return new MetaModelValidatorVisiting.Visitor(){

            @Override
            public boolean visit(ObjectSpecification objectSpec, ValidationFailures validationFailures) {
                List<OneToManyAssociation> objectCollections = objectSpec.getCollections(Contributed.EXCLUDED);
                for (OneToManyAssociation objectCollection : objectCollections) {
                    Class cls;
                    SortedByFacet facet = objectCollection.getFacet(SortedByFacet.class);
                    if (facet == null || Comparator.class.isAssignableFrom(cls = (Class)facet.value())) continue;
                    validationFailures.add("%s#%s is annotated with @SortedBy, but the class specified '%s' is not a Comparator", objectSpec.getIdentifier().getClassName(), objectCollection.getId(), ((Class)facet.value()).getName());
                }
                return true;
            }
        };
    }

    @Override
    public void setServicesInjector(ServicesInjector servicesInjector) {
        this.servicesInjector = servicesInjector;
    }
}

