/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.properties.event;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import org.apache.isis.applib.FatalException;
import org.apache.isis.applib.Identifier;
import org.apache.isis.applib.services.eventbus.PropertyChangedEvent;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.accessor.PropertyOrCollectionAccessorFacet;
import org.apache.isis.core.metamodel.facets.properties.event.PostsPropertyChangedEventClearFacet;
import org.apache.isis.core.metamodel.facets.properties.event.PostsPropertyChangedEventClearFacetAbstract;
import org.apache.isis.core.metamodel.facets.properties.modify.PropertyClearFacet;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjector;
import org.apache.isis.core.progmodel.facets.properties.event.Helper;

public class PostsPropertyChangedEventClearFacetAnnotation
extends PostsPropertyChangedEventClearFacetAbstract {
    private final PropertyOrCollectionAccessorFacet getterFacet;
    private final PropertyClearFacet clearFacet;
    private final Helper helper;

    public PostsPropertyChangedEventClearFacetAnnotation(Class<? extends PropertyChangedEvent<?, ?>> eventType, PropertyOrCollectionAccessorFacet getterFacet, PropertyClearFacet clearFacet, ServicesInjector servicesInjector, FacetHolder holder) {
        super(eventType, holder);
        this.getterFacet = getterFacet;
        this.clearFacet = clearFacet;
        this.helper = new Helper(servicesInjector);
    }

    @Override
    public void clearProperty(ObjectAdapter targetAdapter) {
        if (this.clearFacet == null) {
            return;
        }
        if (this.helper.getEventBusService() == null) {
            this.clearFacet.clearProperty(targetAdapter);
            return;
        }
        Object oldValue = this.getterFacet.getProperty(targetAdapter);
        this.clearFacet.clearProperty(targetAdapter);
        Object newValue = this.getterFacet.getProperty(targetAdapter);
        this.postEventIfChanged(targetAdapter, this.getIdentified().getIdentifier(), oldValue, newValue);
    }

    private void postEventIfChanged(ObjectAdapter targetAdapter, Identifier identifier, Object oldValue, Object newValue) {
        if (Objects.equal((Object)oldValue, (Object)newValue)) {
            return;
        }
        try {
            Class type = (Class)this.value();
            Object source = ObjectAdapter.Util.unwrap(targetAdapter);
            PropertyChangedEvent<Object, Object> event = PostsPropertyChangedEventClearFacet.Util.newEvent(type, source, identifier, oldValue, newValue);
            this.helper.postEvent(event);
        }
        catch (Exception e) {
            throw new FatalException((Throwable)e);
        }
    }

    @Override
    public Class<? extends Facet>[] facetTypes() {
        return Lists.newArrayList((Object[])new Class[]{PostsPropertyChangedEventClearFacetAnnotation.type(), PostsPropertyChangedEventClearFacet.class}).toArray(new Class[0]);
    }

    @Override
    public <T extends Facet> T getFacet(Class<T> facet) {
        return (T)this;
    }
}

