/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.properties.event;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import org.apache.isis.applib.FatalException;
import org.apache.isis.applib.Identifier;
import org.apache.isis.applib.services.eventbus.PropertyChangedEvent;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.accessor.PropertyOrCollectionAccessorFacet;
import org.apache.isis.core.metamodel.facets.properties.event.PostsPropertyChangedEventSetterFacet;
import org.apache.isis.core.metamodel.facets.properties.event.PostsPropertyChangedEventSetterFacetAbstract;
import org.apache.isis.core.metamodel.facets.properties.modify.PropertySetterFacet;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjector;
import org.apache.isis.core.progmodel.facets.properties.event.Helper;

public class PostsPropertyChangedEventSetterFacetAnnotation
extends PostsPropertyChangedEventSetterFacetAbstract {
    private final PropertyOrCollectionAccessorFacet getterFacet;
    private final PropertySetterFacet setterFacet;
    private final Helper helper;

    public PostsPropertyChangedEventSetterFacetAnnotation(Class<? extends PropertyChangedEvent<?, ?>> eventType, PropertyOrCollectionAccessorFacet getterFacet, PropertySetterFacet setterFacet, ServicesInjector servicesInjector, FacetHolder holder) {
        super(eventType, holder);
        this.getterFacet = getterFacet;
        this.setterFacet = setterFacet;
        this.helper = new Helper(servicesInjector);
    }

    @Override
    public void setProperty(ObjectAdapter targetAdapter, ObjectAdapter valueAdapter) {
        if (this.setterFacet == null) {
            return;
        }
        if (this.helper.getEventBusService() == null) {
            this.setterFacet.setProperty(targetAdapter, valueAdapter);
            return;
        }
        Object oldValue = this.getterFacet.getProperty(targetAdapter);
        this.setterFacet.setProperty(targetAdapter, valueAdapter);
        Object newValue = this.getterFacet.getProperty(targetAdapter);
        this.postEventIfChanged(targetAdapter, this.getIdentified().getIdentifier(), oldValue, newValue);
    }

    private void postEventIfChanged(ObjectAdapter targetAdapter, Identifier identifier, Object oldValue, Object newValue) {
        if (Objects.equal((Object)oldValue, (Object)newValue)) {
            return;
        }
        try {
            Class type = (Class)this.value();
            Object source = ObjectAdapter.Util.unwrap(targetAdapter);
            PropertyChangedEvent<Object, Object> event = PostsPropertyChangedEventSetterFacet.Util.newEvent(type, source, identifier, oldValue, newValue);
            this.helper.postEvent(event);
        }
        catch (Exception e) {
            throw new FatalException((Throwable)e);
        }
    }

    @Override
    public Class<? extends Facet>[] facetTypes() {
        return Lists.newArrayList((Object[])new Class[]{PostsPropertyChangedEventSetterFacetAnnotation.type(), PostsPropertyChangedEventSetterFacet.class}).toArray(new Class[0]);
    }

    @Override
    public <T extends Facet> T getFacet(Class<T> facet) {
        return (T)this;
    }
}

