/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.properties.mandatory.annotation;

import org.apache.isis.applib.annotation.Optional;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.mandatory.MandatoryFacet;
import org.apache.isis.core.progmodel.facets.properties.mandatory.annotation.MandatoryFacetInvertedByOptionalForProperty;

public class OptionalAnnotationForPropertyFacetFactory
extends FacetFactoryAbstract {
    public OptionalAnnotationForPropertyFacetFactory() {
        super(FeatureType.PROPERTIES_ONLY);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        Class<?> returnType = processMethodContext.getMethod().getReturnType();
        if (returnType.isPrimitive()) {
            return;
        }
        if (!Annotations.isAnnotationPresent(processMethodContext.getMethod(), Optional.class)) {
            return;
        }
        Optional annotation = Annotations.getAnnotation(processMethodContext.getMethod(), Optional.class);
        FacetUtil.addFacet(this.create(annotation, (FacetHolder)processMethodContext.getFacetHolder()));
    }

    private MandatoryFacet create(Optional annotation, FacetHolder holder) {
        return annotation != null ? new MandatoryFacetInvertedByOptionalForProperty(holder) : null;
    }
}

