/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.properties.multiline.annotation;

import java.util.Properties;
import org.apache.isis.applib.annotation.MultiLine;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.ContributeeMemberFacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.multiline.MultiLineFacet;
import org.apache.isis.core.progmodel.facets.properties.multiline.annotation.MultiLineFacetOnPropertyAnnotation;
import org.apache.isis.core.progmodel.facets.properties.multiline.annotation.MultiLineFacetOnPropertyFromProperties;

public class MultiLineOnPropertyFacetFactory
extends FacetFactoryAbstract
implements ContributeeMemberFacetFactory {
    public MultiLineOnPropertyFacetFactory() {
        super(FeatureType.PROPERTIES_ONLY);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        MultiLineFacet facet = MultiLineOnPropertyFacetFactory.createFromMetadataPropertiesIfPossible(processMethodContext);
        if (facet == null) {
            facet = MultiLineOnPropertyFacetFactory.createFromAnnotationIfPossible(processMethodContext);
        }
        FacetUtil.addFacet(facet);
    }

    @Override
    public void process(ContributeeMemberFacetFactory.ProcessContributeeMemberContext processMemberContext) {
    }

    private static MultiLineFacet createFromMetadataPropertiesIfPossible(FacetFactory.ProcessContextWithMetadataProperties<? extends FacetHolder> pcwmp) {
        FacetHolder holder = pcwmp.getFacetHolder();
        Properties properties = pcwmp.metadataProperties("multiLine");
        return properties != null ? new MultiLineFacetOnPropertyFromProperties(properties, holder) : null;
    }

    private static MultiLineFacetOnPropertyAnnotation createFromAnnotationIfPossible(FacetFactory.ProcessMethodContext processMethodContext) {
        Class<?> returnType = processMethodContext.getMethod().getReturnType();
        if (!Annotations.isString(returnType)) {
            return null;
        }
        MultiLine annotation = Annotations.getAnnotation(processMethodContext.getMethod(), MultiLine.class);
        return annotation != null ? new MultiLineFacetOnPropertyAnnotation(annotation.numberOfLines(), annotation.preventWrapping(), (FacetHolder)processMethodContext.getFacetHolder()) : null;
    }
}

