/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.value;

import com.google.common.collect.Maps;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TimeZone;
import org.apache.isis.applib.adapters.EncodingException;
import org.apache.isis.applib.profiles.Localization;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.parseable.TextEntryParseException;
import org.apache.isis.core.progmodel.facets.object.value.ValueSemanticsProviderAndFacetAbstract;
import org.apache.isis.core.progmodel.facets.object.value.ValueSemanticsProviderContext;
import org.apache.isis.core.progmodel.facets.value.date.DateValueFacet;

public abstract class ValueSemanticsProviderAbstractTemporal<T>
extends ValueSemanticsProviderAndFacetAbstract<T>
implements DateValueFacet {
    private static final ThreadLocal<Map<String, String>> FORMATS = new ThreadLocal<Map<String, String>>(){

        @Override
        protected Map<String, String> initialValue() {
            return Maps.newHashMap();
        }
    };
    protected static final String ISO_ENCODING_FORMAT = "iso_encoding";
    protected static final TimeZone UTC_TIME_ZONE;
    public static final String FORMAT_KEY_PREFIX = "isis.value.format.";
    private final DateFormat encodingFormat;
    protected DateFormat format;
    private String configuredFormat;
    private String propertyType;

    public static void setFormat(String propertyType, String formatStr) {
        FORMATS.get().put(propertyType, formatStr);
    }

    public static Class<? extends Facet> type() {
        return DateValueFacet.class;
    }

    protected static DateFormat createDateFormat(String mask) {
        return new SimpleDateFormat(mask);
    }

    protected static DateFormat createDateEncodingFormat(String mask) {
        DateFormat encodingFormat = ValueSemanticsProviderAbstractTemporal.createDateFormat(mask);
        encodingFormat.setTimeZone(UTC_TIME_ZONE);
        return encodingFormat;
    }

    public ValueSemanticsProviderAbstractTemporal(String propertyName, FacetHolder holder, Class<T> adaptedClass, int typicalLength, ValueSemanticsProviderAndFacetAbstract.Immutability immutability, ValueSemanticsProviderAndFacetAbstract.EqualByContent equalByContent, T defaultValue, IsisConfiguration configuration, ValueSemanticsProviderContext context) {
        this(propertyName, ValueSemanticsProviderAbstractTemporal.type(), holder, adaptedClass, typicalLength, immutability, equalByContent, defaultValue, configuration, context);
    }

    public ValueSemanticsProviderAbstractTemporal(String propertyType, Class<? extends Facet> facetType, FacetHolder holder, Class<T> adaptedClass, int typicalLength, ValueSemanticsProviderAndFacetAbstract.Immutability immutability, ValueSemanticsProviderAndFacetAbstract.EqualByContent equalByContent, T defaultValue, IsisConfiguration configuration, ValueSemanticsProviderContext context) {
        super(facetType, holder, adaptedClass, typicalLength, immutability, equalByContent, defaultValue, configuration, context);
        this.configureFormats();
        this.propertyType = propertyType;
        this.configuredFormat = this.getConfiguration().getString(FORMAT_KEY_PREFIX + propertyType, this.defaultFormat()).toLowerCase().trim();
        this.buildFormat(this.configuredFormat);
        this.encodingFormat = this.formats().get(ISO_ENCODING_FORMAT);
    }

    protected void configureFormats() {
        Map<String, DateFormat> formats = this.formats();
        for (Map.Entry<String, DateFormat> mapEntry : formats.entrySet()) {
            DateFormat format = mapEntry.getValue();
            format.setLenient(false);
            if (!this.ignoreTimeZone()) continue;
            format.setTimeZone(UTC_TIME_ZONE);
        }
    }

    protected void buildDefaultFormatIfRequired() {
        Map<String, String> map = FORMATS.get();
        String currentlyConfiguredFormat = map.get(this.propertyType);
        if (currentlyConfiguredFormat == null || this.configuredFormat.equals(currentlyConfiguredFormat)) {
            return;
        }
        this.configuredFormat = currentlyConfiguredFormat;
        this.buildFormat(this.configuredFormat);
    }

    protected void buildFormat(String configuredFormat) {
        Map<String, DateFormat> formats = this.formats();
        this.format = formats.get(configuredFormat);
        if (this.format == null) {
            this.setMask(configuredFormat);
        }
    }

    @Override
    protected T doParse(Object context, String entry, Localization localization) {
        this.buildDefaultFormatIfRequired();
        String dateString = entry.trim();
        String str = dateString.toLowerCase();
        if (str.equals("today") || str.equals("now")) {
            return this.now();
        }
        if (dateString.startsWith("+")) {
            return this.relativeDate(context == null ? this.now() : context, dateString, true);
        }
        if (dateString.startsWith("-")) {
            return this.relativeDate(context == null ? this.now() : context, dateString, false);
        }
        return this.parseDate(dateString, context == null ? this.now() : context, localization);
    }

    private T parseDate(String dateString, Object original, Localization localization) {
        List<DateFormat> elements = this.formatsToTry(localization);
        return this.setDate(this.parseDate(dateString, elements.iterator()));
    }

    protected abstract List<DateFormat> formatsToTry(Localization var1);

    private Date parseDate(String dateString, Iterator<DateFormat> elements) {
        DateFormat format = elements.next();
        try {
            return format.parse(dateString);
        }
        catch (ParseException e) {
            if (elements.hasNext()) {
                return this.parseDate(dateString, elements);
            }
            throw new TextEntryParseException("Not recognised as a date: " + dateString);
        }
    }

    private T relativeDate(Object object, String str, boolean add) {
        if (str.equals("")) {
            return this.now();
        }
        try {
            Object date = object;
            StringTokenizer st = new StringTokenizer(str.substring(1), " ");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                date = this.relativeDate2(date, token, add);
            }
            return (T)date;
        }
        catch (Exception e) {
            return this.now();
        }
    }

    private T relativeDate2(T original, String str, boolean add) {
        int hours = 0;
        int minutes = 0;
        int days = 0;
        int months = 0;
        int years = 0;
        if (str.endsWith("H")) {
            str = str.substring(0, str.length() - 1);
            hours = Integer.valueOf(str);
        } else if (str.endsWith("M")) {
            str = str.substring(0, str.length() - 1);
            minutes = Integer.valueOf(str);
        } else if (str.endsWith("w")) {
            str = str.substring(0, str.length() - 1);
            days = 7 * Integer.valueOf(str);
        } else if (str.endsWith("y")) {
            str = str.substring(0, str.length() - 1);
            years = Integer.valueOf(str);
        } else if (str.endsWith("m")) {
            str = str.substring(0, str.length() - 1);
            months = Integer.valueOf(str);
        } else if (str.endsWith("d")) {
            str = str.substring(0, str.length() - 1);
            days = Integer.valueOf(str);
        } else {
            days = Integer.valueOf(str);
        }
        if (add) {
            return this.add(original, years, months, days, hours, minutes);
        }
        return this.add(original, -years, -months, -days, -hours, -minutes);
    }

    @Override
    public String titleString(Object value, Localization localization) {
        if (value == null) {
            return null;
        }
        Date date = this.dateValue(value);
        DateFormat f = this.format;
        if (localization != null) {
            f = this.format(localization);
        }
        return this.titleString(f, date);
    }

    protected DateFormat format(Localization localization) {
        return this.format;
    }

    @Override
    public String titleStringWithMask(Object value, String usingMask) {
        Date date = this.dateValue(value);
        return this.titleString(new SimpleDateFormat(usingMask), date);
    }

    private String titleString(DateFormat formatter, Date date) {
        return date == null ? "" : formatter.format(date);
    }

    @Override
    protected String doEncode(Object object) {
        Date date = this.dateValue(object);
        return this.encode(date);
    }

    private synchronized String encode(Date date) {
        return this.encodingFormat.format(date);
    }

    @Override
    protected T doRestore(String data) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(UTC_TIME_ZONE);
        try {
            cal.setTime(this.parse(data));
            this.clearFields(cal);
            return this.setDate(cal.getTime());
        }
        catch (ParseException e) {
            if (data.charAt(0) == 'T') {
                long millis = Long.parseLong(data.substring(1));
                cal.setTimeInMillis(millis);
                this.clearFields(cal);
                return this.setDate(cal.getTime());
            }
            throw new EncodingException((Throwable)e);
        }
    }

    private synchronized Date parse(String data) throws ParseException {
        return this.encodingFormat.parse(data);
    }

    @Override
    public final Date dateValue(ObjectAdapter object) {
        return object == null ? null : this.dateValue(object.getObject());
    }

    @Override
    public final ObjectAdapter createValue(Date date) {
        return this.getAdapterManager().adapterFor(this.setDate(date));
    }

    protected abstract T add(T var1, int var2, int var3, int var4, int var5, int var6);

    protected void clearFields(Calendar cal) {
    }

    protected abstract Date dateValue(Object var1);

    protected abstract String defaultFormat();

    protected abstract Map<String, DateFormat> formats();

    protected boolean ignoreTimeZone() {
        return false;
    }

    protected abstract T now();

    protected abstract T setDate(Date var1);

    public void setMask(String mask) {
        this.format = new SimpleDateFormat(mask);
        this.format.setTimeZone(UTC_TIME_ZONE);
        this.format.setLenient(false);
    }

    protected boolean isEmpty() {
        return false;
    }

    static {
        TimeZone timeZone = TimeZone.getTimeZone("Etc/UTC");
        if (timeZone == null) {
            timeZone = TimeZone.getTimeZone("UTC");
        }
        UTC_TIME_ZONE = timeZone;
    }
}

